/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.config.java.mapper;

import java.io.File;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.pkl.config.java.mapper.Conversion;
import org.pkl.config.java.mapper.ConversionException;
import org.pkl.config.java.mapper.Converter;
import org.pkl.core.DataSize;
import org.pkl.core.Duration;
import org.pkl.core.PClass;
import org.pkl.core.PClassInfo;
import org.pkl.core.PModule;
import org.pkl.core.PNull;
import org.pkl.core.PObject;
import org.pkl.core.Version;

public final class Conversions {
    public static final Conversion<Long, Byte> pIntToByte = Conversion.of(PClassInfo.Int, Byte.TYPE, (value2, mapper) -> {
        if (value2 < -128L || value2 > 127L) {
            throw new ConversionException(String.format("Cannot convert pkl.base#Int `%s` to java.lang.Byte because it is outside range `%s..%s`", value2, (byte)-128, (byte)127));
        }
        return value2.byteValue();
    });
    public static final Conversion<Long, Short> pIntToShort = Conversion.of(PClassInfo.Int, Short.TYPE, (value2, mapper) -> {
        if (value2 < -32768L || value2 > 32767L) {
            throw new ConversionException(String.format("Cannot convert pkl.base#Int `%s` to java.lang.Short because it is outside range `%s..%s`", value2, (short)Short.MIN_VALUE, (short)Short.MAX_VALUE));
        }
        return value2.shortValue();
    });
    public static final Conversion<Long, Integer> pIntToInteger = Conversion.of(PClassInfo.Int, Integer.TYPE, (value2, mapper) -> {
        if (value2 < Integer.MIN_VALUE || value2 > Integer.MAX_VALUE) {
            throw new ConversionException(String.format("Cannot convert pkl.base#Int `%s` to java.lang.Integer because it is outside range `%s..%s`", value2, Integer.MIN_VALUE, Integer.MAX_VALUE));
        }
        return value2.intValue();
    });
    public static final Conversion<Long, Float> pIntToFloat = Conversion.of(PClassInfo.Int, Float.TYPE, (value2, mapper) -> Float.valueOf(value2.floatValue()));
    public static final Conversion<Long, Double> pIntToDouble = Conversion.of(PClassInfo.Int, Double.TYPE, (value2, mapper) -> value2.doubleValue());
    public static final Conversion<Long, BigInteger> pIntToBigInteger = Conversion.of(PClassInfo.Int, BigInteger.class, (value2, mapper) -> BigInteger.valueOf(value2));
    public static final Conversion<Long, BigDecimal> pIntToBigDecimal = Conversion.of(PClassInfo.Int, BigDecimal.class, (value2, mapper) -> BigDecimal.valueOf(value2));
    public static final Conversion<Double, Float> pFloatToFloat = Conversion.of(PClassInfo.Float, Float.TYPE, (value2, mapper) -> Float.valueOf(value2.floatValue()));
    public static final Conversion<Double, BigDecimal> pFloatToBigDecimal = Conversion.of(PClassInfo.Float, BigDecimal.class, (value2, mapper) -> BigDecimal.valueOf(value2));
    public static final Conversion<String, Character> pStringToCharacter = Conversion.of(PClassInfo.String, Character.class, (value2, mapper) -> {
        if (value2.length() != 1) {
            throw new ConversionException(String.format("Cannot convert pkl.base#String `%s` to java.lang.Character because it is not of length 1.", value2));
        }
        return Character.valueOf(value2.charAt(0));
    });
    public static final Conversion<String, URI> pStringToURI = Conversion.of(PClassInfo.String, URI.class, (value2, mapper) -> {
        try {
            return new URI((String)value2);
        }
        catch (URISyntaxException e2) {
            throw new ConversionException("Failed to convert `pkl.base#String` to `java.net.URI`.", e2);
        }
    });
    public static final Conversion<String, URL> pStringToURL = Conversion.of(PClassInfo.String, URL.class, (value2, mapper) -> {
        try {
            return new URL((String)value2);
        }
        catch (MalformedURLException e2) {
            throw new ConversionException("Failed to convert `pkl.base#String` to `java.net.URL`.", e2);
        }
    });
    public static final Conversion<String, File> pStringToFile = Conversion.of(PClassInfo.String, File.class, (value2, mapper) -> new File((String)value2));
    public static final Conversion<String, Path> pStringToPath = Conversion.of(PClassInfo.String, Path.class, (value2, mapper) -> {
        try {
            return Path.of(value2, new String[0]);
        }
        catch (InvalidPathException e2) {
            throw new ConversionException("Failed to convert `pkl.base#String` to `java.nio.file.Path`.", e2);
        }
    });
    public static final Conversion<String, Pattern> pStringToPattern = Conversion.of(PClassInfo.String, Pattern.class, (value2, mapper) -> {
        try {
            return Pattern.compile(value2);
        }
        catch (PatternSyntaxException e2) {
            throw new ConversionException("Failed to convert `pkl.base#String` to `java.util.regex.Pattern`.", e2);
        }
    });
    public static final Conversion<Pattern, String> pRegexToString = Conversion.of(PClassInfo.Regex, String.class, (value2, mapper) -> value2.pattern());
    public static final Conversion<Duration, java.time.Duration> pDurationToDuration = Conversion.of(PClassInfo.Duration, java.time.Duration.class, (value2, mapper) -> value2.toJavaDuration());
    public static final Conversion<PObject, Version> pVersionToVersion = Conversion.of(PClassInfo.Version, Version.class, (value2, mapper) -> {
        try {
            return new Version(Math.toIntExact((Long)value2.getProperty("major")), Math.toIntExact((Long)value2.getProperty("minor")), Math.toIntExact((Long)value2.getProperty("patch")), (String)value2.get("preRelease"), (String)value2.get("build"));
        }
        catch (ArithmeticException e2) {
            throw new ConversionException("Failed to convert `pkl.semver#Version` to `org.pkl.core.Version`.", e2);
        }
    });
    public static final Conversion<PObject, String> pVersionToString = Conversion.of(PClassInfo.Version, String.class, (value2, mapper) -> {
        Object build;
        StringBuilder builder = new StringBuilder();
        builder.append(value2.get("major"));
        builder.append('.');
        builder.append(value2.get("minor"));
        builder.append('.');
        builder.append(value2.get("patch"));
        Object preRelease = value2.get("preRelease");
        if (preRelease != null) {
            builder.append('-');
            builder.append(preRelease);
        }
        if ((build = value2.get("build")) != null) {
            builder.append('+');
            builder.append(build);
        }
        return builder.toString();
    });
    public static final Conversion<String, Version> pStringToVersion = Conversion.of(PClassInfo.String, Version.class, (value2, mapper) -> {
        try {
            return Version.parse(value2);
        }
        catch (IllegalArgumentException e2) {
            throw new ConversionException("Failed to convert `pkl.base#String` to `org.pkl.core.Version`.", e2);
        }
    });
    public static final Collection<Conversion<?, ?>> identities = List.of(Conversion.of(PClassInfo.Boolean, Boolean.TYPE, Converter.identity()), Conversion.of(PClassInfo.Boolean, Object.class, Converter.identity()), Conversion.of(PClassInfo.String, String.class, Converter.identity()), Conversion.of(PClassInfo.String, Object.class, Converter.identity()), Conversion.of(PClassInfo.Int, Long.TYPE, Converter.identity()), Conversion.of(PClassInfo.Int, Number.class, Converter.identity()), Conversion.of(PClassInfo.Int, Object.class, Converter.identity()), Conversion.of(PClassInfo.Float, Double.TYPE, Converter.identity()), Conversion.of(PClassInfo.Float, Number.class, Converter.identity()), Conversion.of(PClassInfo.Float, Object.class, Converter.identity()), Conversion.of(PClassInfo.Duration, Duration.class, Converter.identity()), Conversion.of(PClassInfo.Duration, Object.class, Converter.identity()), Conversion.of(PClassInfo.DataSize, DataSize.class, Converter.identity()), Conversion.of(PClassInfo.DataSize, Object.class, Converter.identity()), Conversion.of(PClassInfo.Module, PModule.class, Converter.identity()), Conversion.of(PClassInfo.Module, Object.class, Converter.identity()), Conversion.of(PClassInfo.Class, PClass.class, Converter.identity()), Conversion.of(PClassInfo.Class, Object.class, Converter.identity()), Conversion.of(PClassInfo.Regex, Pattern.class, Converter.identity()), Conversion.of(PClassInfo.Regex, Object.class, Converter.identity()), Conversion.of(PClassInfo.Null, PNull.class, Converter.identity()));
    public static final Collection<Conversion<?, ?>> numeric = List.of(pIntToByte, pIntToShort, pIntToInteger, pIntToFloat, pIntToDouble, pIntToBigInteger, pIntToBigDecimal, pFloatToFloat, pFloatToBigDecimal);
    public static final Collection<Conversion<?, ?>> misc = List.of(pStringToCharacter, pStringToURI, pStringToURL, pStringToFile, pStringToPath, pStringToPattern, pRegexToString, pDurationToDuration, pVersionToVersion, pVersionToString, pStringToVersion);
    public static final Collection<Conversion<?, ?>> all = Conversions.collectAll();

    private Conversions() {
    }

    private static Collection<Conversion<?, ?>> collectAll() {
        ArrayList result2 = new ArrayList(identities.size() + numeric.size() + misc.size());
        result2.addAll(identities);
        result2.addAll(numeric);
        result2.addAll(misc);
        return Collections.unmodifiableList(result2);
    }
}

