/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.config.java.mapper;

import java.lang.reflect.Type;
import java.util.Map;
import java.util.Optional;
import org.pkl.config.java.mapper.ConversionException;
import org.pkl.config.java.mapper.Converter;
import org.pkl.config.java.mapper.ConverterFactory;
import org.pkl.config.java.mapper.Reflection;
import org.pkl.config.java.mapper.ValueMapper;
import org.pkl.core.DataSizeUnit;
import org.pkl.core.DurationUnit;
import org.pkl.core.PClassInfo;
import org.pkl.core.util.CodeGeneratorUtils;
import org.pkl.core.util.CollectionUtils;

final class PStringToEnum
implements ConverterFactory {
    PStringToEnum() {
    }

    @Override
    public Optional<Converter<?, ?>> create(PClassInfo<?> sourceType, Type targetType) {
        Class<?> rawTargetType = Reflection.toRawType(targetType);
        if (sourceType != PClassInfo.String || !rawTargetType.isEnum()) {
            return Optional.empty();
        }
        return Optional.of(new ConverterImpl(rawTargetType));
    }

    private static final class ConverterImpl
    implements Converter<String, Enum<?>> {
        private final Class<?> enumType;
        private final Map<String, Enum<?>> enumValuesByName;

        private ConverterImpl(Class<?> enumType) {
            this.enumType = enumType;
            Enum[] values2 = (Enum[])enumType.getEnumConstants();
            this.enumValuesByName = CollectionUtils.newConcurrentHashMap(values2.length);
            if (enumType == DataSizeUnit.class) {
                for (Enum value2 : values2) {
                    DataSizeUnit unit2 = (DataSizeUnit)value2;
                    this.enumValuesByName.put(CodeGeneratorUtils.toEnumConstantName(unit2.getSymbol()), value2);
                }
            } else if (enumType == DurationUnit.class) {
                for (Enum value3 : values2) {
                    DurationUnit unit3 = (DurationUnit)value3;
                    this.enumValuesByName.put(CodeGeneratorUtils.toEnumConstantName(unit3.getSymbol()), value3);
                }
            } else {
                for (Enum value4 : values2) {
                    this.enumValuesByName.put(value4.name(), value4);
                }
            }
        }

        @Override
        public Enum<?> convert(String value2, ValueMapper valueMapper) {
            Enum<?> enumValue = this.enumValuesByName.get(value2);
            if (enumValue == null && (enumValue = this.enumValuesByName.get(CodeGeneratorUtils.toEnumConstantName(value2))) != null) {
                this.enumValuesByName.put(value2, enumValue);
            }
            if (enumValue != null) {
                return enumValue;
            }
            throw new ConversionException(String.format("Cannot convert String `%s` to Enum value of type `%s`.", value2, this.enumType.getTypeName()));
        }
    }
}

