/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.config.java.mapper;

import java.lang.reflect.Executable;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.Arrays;
import org.pkl.core.util.Nullable;
import org.pkl.thirdparty.geantyref.CaptureType;
import org.pkl.thirdparty.geantyref.GenericTypeReflector;

public final class Reflection {
    private Reflection() {
    }

    @Nullable
    public static Class<?> tryLoadClass(String qualifiedName2) {
        try {
            return Class.forName(qualifiedName2);
        }
        catch (ClassNotFoundException e2) {
            return null;
        }
    }

    public static boolean isMissingTypeArguments(Type type2) {
        if (type2 instanceof WildcardType) {
            WildcardType wildcardType = (WildcardType)type2;
            Type baseType = wildcardType.getLowerBounds().length > 0 ? wildcardType.getLowerBounds()[0] : wildcardType.getUpperBounds()[0];
            return Reflection.isMissingTypeArguments(baseType);
        }
        return GenericTypeReflector.isMissingTypeParameters(type2);
    }

    public static Type normalize(Type type2) {
        if (type2 instanceof WildcardType) {
            WildcardType wildcardType = (WildcardType)type2;
            Type[] bounds = wildcardType.getLowerBounds();
            if (bounds.length > 0) {
                return bounds[0];
            }
            bounds = wildcardType.getUpperBounds();
            if (bounds.length > 0) {
                return bounds[0];
            }
        }
        return Reflection.getExactSupertype(type2, Reflection.toRawType(type2));
    }

    public static Class<?> toRawType(Type type2) {
        return GenericTypeReflector.erase(type2);
    }

    public static <T> Class<T> toWrapperType(Class<T> type2) {
        if (type2 == Boolean.TYPE) {
            return Boolean.class;
        }
        if (type2 == Character.TYPE) {
            return Character.class;
        }
        if (type2 == Long.TYPE) {
            return Long.class;
        }
        if (type2 == Integer.TYPE) {
            return Integer.class;
        }
        if (type2 == Short.TYPE) {
            return Short.class;
        }
        if (type2 == Byte.TYPE) {
            return Byte.class;
        }
        if (type2 == Double.TYPE) {
            return Double.class;
        }
        if (type2 == Float.TYPE) {
            return Float.class;
        }
        return type2;
    }

    public static Type getArrayElementType(Type type2) {
        return GenericTypeReflector.getArrayComponentType(type2);
    }

    public static Type getExactSupertype(Type type2, Class<?> rawSupertype) {
        return Reflection.uncapture(GenericTypeReflector.getExactSuperType(type2, rawSupertype));
    }

    public static Type getExactSubtype(Type type2, Class<?> rawSubtype) {
        return Reflection.uncapture(GenericTypeReflector.getExactSubType(type2, rawSubtype));
    }

    public static Type[] getExactParameterTypes(Executable m, Type declaringType) {
        return (Type[])Arrays.stream(GenericTypeReflector.getExactParameterTypes(m, GenericTypeReflector.annotate(declaringType))).map(annType -> Reflection.uncapture(annType.getType())).toArray(Type[]::new);
    }

    private static Type uncapture(Type type2) {
        if (type2 instanceof CaptureType) {
            CaptureType captureType = (CaptureType)type2;
            return captureType.getWildcardType();
        }
        return type2;
    }
}

