/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core;

import org.pkl.core.util.Nullable;

public enum DataSizeUnit {
    BYTES(1L, "b"),
    KILOBYTES(1000L, "kb"),
    KIBIBYTES(1024L, "kib"),
    MEGABYTES(1000000L, "mb"),
    MEBIBYTES(0x100000L, "mib"),
    GIGABYTES(1000000000L, "gb"),
    GIBIBYTES(0x40000000L, "gib"),
    TERABYTES(1000000000000L, "tb"),
    TEBIBYTES(0x10000000000L, "tib"),
    PETABYTES(1000000000000000L, "pb"),
    PEBIBYTES(0x4000000000000L, "pib");

    private final long bytes;
    private final String symbol;

    private DataSizeUnit(long bytes, String symbol) {
        this.bytes = bytes;
        this.symbol = symbol;
    }

    @Nullable
    public static DataSizeUnit parse(String symbol) {
        return switch (symbol) {
            case "b" -> BYTES;
            case "kb" -> KILOBYTES;
            case "kib" -> KIBIBYTES;
            case "mb" -> MEGABYTES;
            case "mib" -> MEBIBYTES;
            case "gb" -> GIGABYTES;
            case "gib" -> GIBIBYTES;
            case "tb" -> TERABYTES;
            case "tib" -> TEBIBYTES;
            case "pb" -> PETABYTES;
            case "pib" -> PEBIBYTES;
            default -> null;
        };
    }

    public String getSymbol() {
        return this.symbol;
    }

    public long getBytes() {
        return this.bytes;
    }

    public String toString() {
        return this.symbol;
    }
}

