/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.pkl.core.DataSize;
import org.pkl.core.Duration;
import org.pkl.core.PClass;
import org.pkl.core.PModule;
import org.pkl.core.PNull;
import org.pkl.core.PObject;
import org.pkl.core.Pair;
import org.pkl.core.RendererException;
import org.pkl.core.TypeAlias;
import org.pkl.core.ValueRenderer;
import org.pkl.core.ValueVisitor;
import org.pkl.core.util.json.JsonWriter;

final class JsonRenderer
implements ValueRenderer {
    private final JsonWriter writer;
    private final boolean omitNullProperties;

    public JsonRenderer(Writer writer, String indent, boolean omitNullProperties) {
        this.writer = new JsonWriter(writer);
        this.writer.setIndent(indent);
        this.omitNullProperties = omitNullProperties;
    }

    @Override
    public void renderDocument(Object value2) {
        this.renderValue(value2);
        try {
            this.writer.newline();
        }
        catch (IOException e2) {
            throw new UncheckedIOException(e2);
        }
    }

    @Override
    public void renderValue(Object value2) {
        new Visitor().visit(value2);
    }

    private class Visitor
    implements ValueVisitor {
        private Visitor() {
        }

        @Override
        public void visitString(String value2) {
            try {
                JsonRenderer.this.writer.value(value2);
            }
            catch (IOException e2) {
                throw new UncheckedIOException(e2);
            }
        }

        @Override
        public void visitInt(Long value2) {
            try {
                JsonRenderer.this.writer.value(value2);
            }
            catch (IOException e2) {
                throw new UncheckedIOException(e2);
            }
        }

        @Override
        public void visitFloat(Double value2) {
            try {
                JsonRenderer.this.writer.value(value2);
            }
            catch (IOException e2) {
                throw new UncheckedIOException(e2);
            }
        }

        @Override
        public void visitBoolean(Boolean value2) {
            try {
                JsonRenderer.this.writer.value(value2);
            }
            catch (IOException e2) {
                throw new UncheckedIOException(e2);
            }
        }

        @Override
        public void visitDuration(Duration value2) {
            throw new RendererException(String.format("Values of type `Duration` cannot be rendered as JSON. Value: %s", value2));
        }

        @Override
        public void visitDataSize(DataSize value2) {
            throw new RendererException(String.format("Values of type `DataSize` cannot be rendered as JSON. Value: %s", value2));
        }

        @Override
        public void visitPair(Pair<?, ?> value2) {
            try {
                JsonRenderer.this.writer.beginArray();
                this.visit(value2.getFirst());
                this.visit(value2.getSecond());
                JsonRenderer.this.writer.endArray();
            }
            catch (IOException e2) {
                throw new UncheckedIOException(e2);
            }
        }

        @Override
        public void visitList(List<?> value2) {
            this.doVisitCollection(value2);
        }

        @Override
        public void visitSet(Set<?> value2) {
            this.doVisitCollection(value2);
        }

        @Override
        public void visitMap(Map<?, ?> value2) {
            for (Object key2 : value2.keySet()) {
                if (key2 instanceof String) continue;
                throw new RendererException(String.format("Maps containing non-String keys cannot be rendered as JSON. Key: %s", key2));
            }
            Map<?, ?> mapValue = value2;
            this.doVisitProperties(mapValue);
        }

        @Override
        public void visitObject(PObject value2) {
            this.doVisitProperties(value2.getProperties());
        }

        @Override
        public void visitModule(PModule value2) {
            this.doVisitProperties(value2.getProperties());
        }

        @Override
        public void visitNull() {
            try {
                JsonRenderer.this.writer.nullValue();
            }
            catch (IOException e2) {
                throw new UncheckedIOException(e2);
            }
        }

        @Override
        public void visitClass(PClass value2) {
            throw new RendererException(String.format("Values of type `Class` cannot be rendered as JSON. Value: %s", value2.getSimpleName()));
        }

        @Override
        public void visitTypeAlias(TypeAlias value2) {
            throw new RendererException(String.format("Values of type `TypeAlias` cannot be rendered as JSON. Value: %s", value2.getSimpleName()));
        }

        @Override
        public void visitRegex(Pattern value2) {
            throw new RendererException(String.format("Values of type `Regex` cannot be rendered as JSON. Value: %s", value2));
        }

        private void doVisitCollection(Collection<?> collection) {
            try {
                JsonRenderer.this.writer.beginArray();
                for (Object elem : collection) {
                    this.visit(elem);
                }
                JsonRenderer.this.writer.endArray();
            }
            catch (IOException e2) {
                throw new UncheckedIOException(e2);
            }
        }

        private void doVisitProperties(Map<String, ?> properties2) {
            try {
                JsonRenderer.this.writer.beginObject();
                for (Map.Entry<String, ?> entry : properties2.entrySet()) {
                    Object value2 = entry.getValue();
                    if (JsonRenderer.this.omitNullProperties && value2 instanceof PNull) continue;
                    JsonRenderer.this.writer.name(entry.getKey());
                    this.visit(value2);
                }
                JsonRenderer.this.writer.endObject();
            }
            catch (IOException e2) {
                throw new UncheckedIOException(e2);
            }
        }
    }
}

