/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core;

import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.pkl.core.Modifier;
import org.pkl.core.PObject;
import org.pkl.core.util.Nullable;

public abstract class Member
implements Serializable {
    private static final long serialVersionUID = 0L;
    @Nullable
    private final String docComment;
    private final SourceLocation sourceLocation;
    private final Set<Modifier> modifiers;
    private final List<PObject> annotations;
    private final String simpleName;

    public Member(@Nullable String docComment, SourceLocation sourceLocation, Set<Modifier> modifiers, List<PObject> annotations2, String simpleName2) {
        this.docComment = docComment;
        this.sourceLocation = Objects.requireNonNull(sourceLocation, "sourceLocation");
        this.modifiers = Objects.requireNonNull(modifiers, "modifiers");
        this.annotations = Objects.requireNonNull(annotations2, "annotations");
        this.simpleName = Objects.requireNonNull(simpleName2, "simpleName");
    }

    public abstract String getModuleName();

    @Nullable
    public String getDocComment() {
        return this.docComment;
    }

    public SourceLocation getSourceLocation() {
        return this.sourceLocation;
    }

    public Set<Modifier> getModifiers() {
        return this.modifiers;
    }

    public List<PObject> getAnnotations() {
        return this.annotations;
    }

    public boolean isExternal() {
        return this.modifiers.contains((Object)Modifier.EXTERNAL);
    }

    public boolean isAbstract() {
        return this.modifiers.contains((Object)Modifier.ABSTRACT);
    }

    public boolean isHidden() {
        return this.modifiers.contains((Object)Modifier.HIDDEN);
    }

    public boolean isOpen() {
        return this.modifiers.contains((Object)Modifier.OPEN);
    }

    public final boolean isStandardLibraryMember() {
        return this.getModuleName().startsWith("pkl.");
    }

    public String getSimpleName() {
        return this.simpleName;
    }

    public static class SourceLocation
    implements Serializable {
        private static final long serialVersionUID = 0L;
        private final int startLine;
        private final int endLine;

        public SourceLocation(int startLine, int endLine) {
            this.startLine = startLine;
            this.endLine = endLine;
        }

        public int getStartLine() {
            return this.startLine;
        }

        public int getEndLine() {
            return this.endLine;
        }
    }
}

