/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core;

import java.util.Map;
import java.util.Objects;
import org.pkl.core.Composite;
import org.pkl.core.NoSuchPropertyException;
import org.pkl.core.PClassInfo;
import org.pkl.core.ValueConverter;
import org.pkl.core.ValueVisitor;
import org.pkl.core.util.Nullable;

public class PObject
implements Composite {
    private static final long serialVersionUID = 0L;
    protected final PClassInfo<?> classInfo;
    protected final Map<String, Object> properties;

    public PObject(PClassInfo<?> classInfo, Map<String, Object> properties2) {
        this.classInfo = Objects.requireNonNull(classInfo, "classInfo");
        this.properties = Objects.requireNonNull(properties2, "properties");
    }

    @Override
    public final PClassInfo<?> getClassInfo() {
        return this.classInfo;
    }

    @Override
    public final Map<String, Object> getProperties() {
        return this.properties;
    }

    @Override
    public Object getProperty(String name) {
        Object result2 = this.properties.get(name);
        if (result2 != null) {
            return result2;
        }
        throw new NoSuchPropertyException(String.format("Object of type `%s` does not have a property named `%s`. Available properties: %s", this.classInfo.getQualifiedName(), name, this.properties.keySet()), name);
    }

    @Override
    public void accept(ValueVisitor visitor2) {
        visitor2.visitObject(this);
    }

    @Override
    public <T> T accept(ValueConverter<T> converter) {
        return converter.convertObject(this);
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PObject other = (PObject)obj;
        return this.classInfo.equals(other.classInfo) && this.properties.equals(other.properties);
    }

    public int hashCode() {
        return Objects.hash(this.classInfo, this.properties);
    }

    public String toString() {
        return this.render(this.getClassInfo().getDisplayName());
    }

    protected String render(@Nullable String prefix) {
        StringBuilder builder = new StringBuilder();
        if (prefix != null) {
            builder.append(prefix);
            builder.append(" { ");
        } else {
            builder.append("{ ");
        }
        boolean first2 = true;
        for (Map.Entry<String, Object> property : this.properties.entrySet()) {
            if (first2) {
                first2 = false;
            } else {
                builder.append("; ");
            }
            builder.append(property.getKey()).append(" = ").append(property.getValue());
        }
        builder.append(" }");
        return builder.toString();
    }
}

