/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core;

import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.pkl.core.Composite;
import org.pkl.core.DataSize;
import org.pkl.core.Duration;
import org.pkl.core.PClass;
import org.pkl.core.PModule;
import org.pkl.core.PNull;
import org.pkl.core.PObject;
import org.pkl.core.Pair;
import org.pkl.core.RendererException;
import org.pkl.core.TypeAlias;
import org.pkl.core.ValueFormatter;
import org.pkl.core.ValueRenderer;
import org.pkl.core.ValueVisitor;
import org.pkl.core.parser.Lexer;

final class PcfRenderer
implements ValueRenderer {
    private static final String LINE_SEPARATOR = "\n";
    private final Writer writer;
    private final String indent;
    private final boolean omitNullProperties;
    private final ValueFormatter valueFormatter;
    private String currIndent = "";

    public PcfRenderer(Writer writer, String indent, boolean omitNullProperties, boolean useCustomStringDelimiters) {
        this.writer = writer;
        this.indent = indent;
        this.omitNullProperties = omitNullProperties;
        this.valueFormatter = new ValueFormatter(true, useCustomStringDelimiters);
    }

    @Override
    public void renderDocument(Object value2) {
        if (!(value2 instanceof Composite)) {
            throw new RendererException(String.format("The top-level value of a Pcf document must have type `Composite`, but got type `%s`.", value2.getClass().getTypeName()));
        }
        Composite composite = (Composite)value2;
        new Visitor().doVisitProperties(composite.getProperties());
    }

    @Override
    public void renderValue(Object value2) {
        new Visitor().visit(value2);
    }

    private class Visitor
    implements ValueVisitor {
        private Visitor() {
        }

        @Override
        public void visitString(String value2) {
            try {
                PcfRenderer.this.valueFormatter.formatStringValue(value2, (CharSequence)(PcfRenderer.this.currIndent + PcfRenderer.this.indent), PcfRenderer.this.writer);
            }
            catch (IOException e2) {
                throw new RuntimeException(e2);
            }
        }

        @Override
        public void visitInt(Long value2) {
            this.write(value2.toString());
        }

        @Override
        public void visitFloat(Double value2) {
            this.write(value2.toString());
        }

        @Override
        public void visitBoolean(Boolean value2) {
            this.write(value2.toString());
        }

        @Override
        public void visitDuration(Duration value2) {
            this.write(value2.toString());
        }

        @Override
        public void visitDataSize(DataSize value2) {
            this.write(value2.toString());
        }

        @Override
        public void visitPair(Pair<?, ?> value2) {
            this.doVisitIterable(value2, "Pair(");
        }

        @Override
        public void visitList(List<?> value2) {
            this.doVisitIterable(value2, "List(");
        }

        @Override
        public void visitSet(Set<?> value2) {
            this.doVisitIterable(value2, "Set(");
        }

        @Override
        public void visitMap(Map<?, ?> value2) {
            boolean first2 = true;
            this.write("Map(");
            for (Map.Entry<?, ?> entry : value2.entrySet()) {
                if (first2) {
                    first2 = false;
                } else {
                    this.write(", ");
                }
                if (entry.getKey() instanceof Composite) {
                    this.write("new ");
                }
                this.visit(entry.getKey());
                this.write(", ");
                if (entry.getValue() instanceof Composite) {
                    this.write("new ");
                }
                this.visit(entry.getValue());
            }
            this.write(')');
        }

        @Override
        public void visitObject(PObject value2) {
            this.doVisitComposite(value2);
        }

        @Override
        public void visitModule(PModule value2) {
            this.doVisitComposite(value2);
        }

        @Override
        public void visitClass(PClass value2) {
            throw new RendererException(String.format("Values of type `Class` cannot be rendered as Pcf. Value: %s", value2.getSimpleName()));
        }

        @Override
        public void visitTypeAlias(TypeAlias value2) {
            throw new RendererException(String.format("Values of type `TypeAlias` cannot be rendered as Pcf. Value: %s", value2.getSimpleName()));
        }

        @Override
        public void visitNull() {
            this.write("null");
        }

        @Override
        public void visitRegex(Pattern value2) {
            this.write("Regex(");
            this.visitString(value2.pattern());
            this.write(')');
        }

        private void doVisitIterable(Iterable<?> iterable, String prefix) {
            boolean first2 = true;
            this.write(prefix);
            for (Object elem : iterable) {
                if (first2) {
                    first2 = false;
                } else {
                    this.write(", ");
                }
                if (elem == null) {
                    this.write("?");
                    continue;
                }
                if (elem instanceof Composite) {
                    this.write("new ");
                }
                this.visit(elem);
            }
            this.write(')');
        }

        private void doVisitComposite(Composite composite) {
            if (composite.getProperties().isEmpty()) {
                this.write("{}");
                return;
            }
            this.write('{');
            this.write(PcfRenderer.LINE_SEPARATOR);
            PcfRenderer.this.currIndent = PcfRenderer.this.currIndent + PcfRenderer.this.indent;
            this.doVisitProperties(composite.getProperties());
            PcfRenderer.this.currIndent = PcfRenderer.this.currIndent.substring(0, PcfRenderer.this.currIndent.length() - PcfRenderer.this.indent.length());
            this.write(PcfRenderer.this.currIndent);
            this.write('}');
        }

        private void doVisitProperties(Map<String, Object> properties2) {
            properties2.forEach((name, value2) -> {
                if (PcfRenderer.this.omitNullProperties && value2 instanceof PNull) {
                    return;
                }
                this.write(PcfRenderer.this.currIndent);
                this.writeIdentifier((String)name);
                if (value2 == null) {
                    this.write(" = ?");
                } else if (value2 instanceof Composite) {
                    this.write(' ');
                    this.visit(value2);
                } else {
                    this.write(" = ");
                    this.visit(value2);
                }
                this.write(PcfRenderer.LINE_SEPARATOR);
            });
        }

        private void write(char ch) {
            try {
                PcfRenderer.this.writer.write(ch);
            }
            catch (IOException e2) {
                throw new RuntimeException(e2);
            }
        }

        private void write(String str) {
            try {
                PcfRenderer.this.writer.write(str);
            }
            catch (IOException e2) {
                throw new RuntimeException(e2);
            }
        }

        private void writeIdentifier(String identifier) {
            if (Lexer.isRegularIdentifier(identifier)) {
                this.write(identifier);
            } else {
                this.write('`');
                this.write(identifier);
                this.write('`');
            }
        }
    }
}

