/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.ast.builder;

import java.util.List;
import org.pkl.core.parser.antlr.PklParser;
import org.pkl.core.parser.antlr.PklParserBaseVisitor;
import org.pkl.core.runtime.VmExceptionBuilder;
import org.pkl.core.util.Nullable;
import org.pkl.thirdparty.antlr.v4.runtime.ParserRuleContext;
import org.pkl.thirdparty.antlr.v4.runtime.Token;
import org.pkl.thirdparty.antlr.v4.runtime.tree.TerminalNode;
import org.pkl.thirdparty.truffle.api.source.Source;
import org.pkl.thirdparty.truffle.api.source.SourceSection;

public abstract class AbstractAstBuilder<T>
extends PklParserBaseVisitor<T> {
    protected final Source source;

    protected AbstractAstBuilder(Source source2) {
        this.source = source2;
    }

    protected abstract VmExceptionBuilder exceptionBuilder();

    protected String doVisitSingleLineConstantStringPart(List<Token> ts) {
        if (ts.isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        block5: for (Token token : ts) {
            switch (token.getType()) {
                case 99: {
                    builder.append(token.getText());
                    continue block5;
                }
                case 98: {
                    builder.append(this.parseCharacterEscapeSequence(token));
                    continue block5;
                }
                case 97: {
                    builder.appendCodePoint(this.parseUnicodeEscapeSequence(token));
                    continue block5;
                }
            }
            throw this.exceptionBuilder().unreachableCode().build();
        }
        return builder.toString();
    }

    protected int parseUnicodeEscapeSequence(Token token) {
        int lastIndex2;
        String text = token.getText();
        if (text.charAt(lastIndex2 = text.length() - 1) != '}') {
            throw this.exceptionBuilder().evalError("unterminatedUnicodeEscapeSequence", token.getText()).withSourceSection(this.createSourceSection(token)).build();
        }
        int startIndex = text.indexOf(123, 2);
        assert (startIndex != -1);
        try {
            return Integer.parseInt(text.substring(startIndex + 1, lastIndex2), 16);
        }
        catch (NumberFormatException e2) {
            throw this.exceptionBuilder().evalError("invalidUnicodeEscapeSequence", token.getText(), text.substring(0, startIndex)).withSourceSection(this.createSourceSection(token)).build();
        }
    }

    protected String parseCharacterEscapeSequence(Token token) {
        String text = token.getText();
        char lastChar = text.charAt(text.length() - 1);
        return switch (lastChar) {
            case 'n' -> "\n";
            case 'r' -> "\r";
            case 't' -> "\t";
            case '\"' -> "\"";
            case '\\' -> "\\";
            default -> throw this.exceptionBuilder().evalError("invalidCharacterEscapeSequence", text, text.substring(0, text.length() - 1)).withSourceSection(this.createSourceSection(token)).build();
        };
    }

    protected final SourceSection createSourceSection(ParserRuleContext ctx) {
        return this.createSourceSection(ctx.getStart(), ctx.getStop());
    }

    protected final SourceSection createSourceSection(TerminalNode node) {
        return this.createSourceSection(node.getSymbol());
    }

    @Nullable
    protected final SourceSection createSourceSection(@Nullable Token token) {
        return token != null ? this.createSourceSection(token, token) : null;
    }

    protected final SourceSection createSourceSection(Token start2, Token stop) {
        return this.source.createSection(start2.getStartIndex(), stop.getStopIndex() - start2.getStartIndex() + 1);
    }

    protected final SourceSection createSourceSection(List<? extends PklParser.ModifierContext> modifierCtxs, int symbol) {
        PklParser.ModifierContext modifierCtx = modifierCtxs.stream().filter(ctx -> ctx.t.getType() == symbol).findFirst().orElseThrow();
        return this.createSourceSection(modifierCtx);
    }

    protected static SourceSection createSourceSection(Source source2, ParserRuleContext ctx) {
        int start2 = ctx.start.getStartIndex();
        int stop = ctx.stop.getStopIndex();
        return source2.createSection(start2, stop - start2 + 1);
    }

    @Nullable
    protected static SourceSection createSourceSection(Source source2, @Nullable Token token) {
        if (token == null) {
            return null;
        }
        int start2 = token.getStartIndex();
        int stop = token.getStopIndex();
        return source2.createSection(start2, stop - start2 + 1);
    }
}

