/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.ast.builder;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.pkl.core.ast.builder.AbstractAstBuilder;
import org.pkl.core.module.ModuleKey;
import org.pkl.core.module.ResolvedModuleKey;
import org.pkl.core.parser.Parser;
import org.pkl.core.parser.antlr.PklParser;
import org.pkl.core.runtime.VmExceptionBuilder;
import org.pkl.core.runtime.VmUtils;
import org.pkl.core.util.Nullable;
import org.pkl.core.util.Pair;
import org.pkl.thirdparty.antlr.v4.runtime.Token;
import org.pkl.thirdparty.truffle.api.source.Source;
import org.pkl.thirdparty.truffle.api.source.SourceSection;

public final class ImportsAndReadsParser
extends AbstractAstBuilder<List<Pair<String, SourceSection>>> {
    @Nullable
    public static List<Pair<String, SourceSection>> parse(ModuleKey moduleKey, ResolvedModuleKey resolvedModuleKey) throws IOException {
        Parser parser = new Parser();
        String text = resolvedModuleKey.loadSource();
        Source source2 = VmUtils.createSource(moduleKey, text);
        ImportsAndReadsParser importListParser = new ImportsAndReadsParser(source2);
        return parser.parseModule(text).accept(importListParser);
    }

    public ImportsAndReadsParser(Source source2) {
        super(source2);
    }

    @Override
    protected VmExceptionBuilder exceptionBuilder() {
        return new VmExceptionBuilder();
    }

    @Override
    public List<Pair<String, SourceSection>> visitModuleExtendsOrAmendsClause(PklParser.ModuleExtendsOrAmendsClauseContext ctx) {
        String importStr = this.doVisitSingleLineConstantStringPart(ctx.stringConstant().ts);
        SourceSection sourceSection = this.createSourceSection(ctx.stringConstant());
        return Collections.singletonList(Pair.of(importStr, sourceSection));
    }

    @Override
    public List<Pair<String, SourceSection>> visitImportClause(PklParser.ImportClauseContext ctx) {
        String importStr = this.doVisitSingleLineConstantStringPart(ctx.stringConstant().ts);
        SourceSection sourceSection = this.createSourceSection(ctx.stringConstant());
        return Collections.singletonList(Pair.of(importStr, sourceSection));
    }

    @Override
    public List<Pair<String, SourceSection>> visitImportExpr(PklParser.ImportExprContext ctx) {
        String importStr = this.doVisitSingleLineConstantStringPart(ctx.stringConstant().ts);
        SourceSection sourceSection = this.createSourceSection(ctx.stringConstant());
        return Collections.singletonList(Pair.of(importStr, sourceSection));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public List<Pair<String, SourceSection>> visitReadExpr(PklParser.ReadExprContext ctx) {
        String importString;
        PklParser.ExprContext expr = ctx.expr();
        if (!(expr instanceof PklParser.SingleLineStringLiteralContext)) {
            return Collections.emptyList();
        }
        PklParser.SingleLineStringLiteralContext slCtx = (PklParser.SingleLineStringLiteralContext)expr;
        List<? extends PklParser.SingleLineStringPartContext> singleParts = slCtx.singleLineStringPart();
        if (singleParts.isEmpty()) {
            importString = "";
            return Collections.singletonList(Pair.of(importString, this.createSourceSection(slCtx)));
        } else {
            if (singleParts.size() != 1) return Collections.emptyList();
            List<Token> ts = singleParts.get((int)0).ts;
            if (ts.isEmpty()) return Collections.emptyList();
            importString = this.doVisitSingleLineConstantStringPart(ts);
        }
        return Collections.singletonList(Pair.of(importString, this.createSourceSection(slCtx)));
    }

    @Override
    @Nullable
    protected List<Pair<String, SourceSection>> aggregateResult(@Nullable List<Pair<String, SourceSection>> aggregate, @Nullable List<Pair<String, SourceSection>> nextResult) {
        if (aggregate == null || aggregate.isEmpty()) {
            return nextResult;
        }
        if (nextResult == null || nextResult.isEmpty()) {
            return aggregate;
        }
        ArrayList<Pair<String, SourceSection>> ret = new ArrayList<Pair<String, SourceSection>>(aggregate.size() + nextResult.size());
        ret.addAll(aggregate);
        ret.addAll(nextResult);
        return ret;
    }
}

