/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.ast.expression.binary;

import org.pkl.core.ast.expression.binary.BinaryExpressionNode;
import org.pkl.core.runtime.VmDataSize;
import org.pkl.core.runtime.VmDuration;
import org.pkl.core.runtime.VmException;
import org.pkl.thirdparty.truffle.api.CompilerDirectives;
import org.pkl.thirdparty.truffle.api.dsl.Specialization;
import org.pkl.thirdparty.truffle.api.nodes.NodeInfo;
import org.pkl.thirdparty.truffle.api.source.SourceSection;

@NodeInfo(shortName="*")
public abstract class MultiplicationNode
extends BinaryExpressionNode {
    protected MultiplicationNode(SourceSection sourceSection) {
        super(sourceSection);
    }

    @Specialization
    protected long eval(long left, long right) {
        try {
            return StrictMath.multiplyExact(left, right);
        }
        catch (VmException e2) {
            CompilerDirectives.transferToInterpreter();
            throw this.exceptionBuilder().evalError("integerOverflow", new Object[0]).build();
        }
    }

    @Specialization
    protected double eval(long left, double right) {
        return (double)left * right;
    }

    @Specialization
    protected double eval(double left, long right) {
        return left * (double)right;
    }

    @Specialization
    protected double eval(double left, double right) {
        return left * right;
    }

    @Specialization
    protected VmDuration eval(VmDuration left, long right) {
        return left.multiply(right);
    }

    @Specialization
    protected VmDuration eval(VmDuration left, double right) {
        return left.multiply(right);
    }

    @Specialization
    protected VmDuration eval(long left, VmDuration right) {
        return right.multiply(left);
    }

    @Specialization
    protected VmDuration eval(double left, VmDuration right) {
        return right.multiply(left);
    }

    @Specialization
    protected VmDataSize eval(VmDataSize left, long right) {
        return left.multiply(right);
    }

    @Specialization
    protected VmDataSize eval(VmDataSize left, double right) {
        return left.multiply(right);
    }

    @Specialization
    protected VmDataSize eval(long left, VmDataSize right) {
        return right.multiply(left);
    }

    @Specialization
    protected VmDataSize eval(double left, VmDataSize right) {
        return right.multiply(left);
    }
}

