/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.ast.expression.generator;

import org.pkl.core.ast.expression.generator.GeneratorMemberNode;
import org.pkl.core.ast.member.ObjectMember;
import org.pkl.core.runtime.BaseModule;
import org.pkl.core.runtime.VmClass;
import org.pkl.core.runtime.VmDynamic;
import org.pkl.core.runtime.VmListing;
import org.pkl.core.util.EconomicMaps;
import org.pkl.thirdparty.truffle.api.CompilerDirectives;
import org.pkl.thirdparty.truffle.api.dsl.Fallback;
import org.pkl.thirdparty.truffle.api.dsl.ImportStatic;
import org.pkl.thirdparty.truffle.api.dsl.Specialization;

@ImportStatic(value={BaseModule.class})
public abstract class GeneratorElementNode
extends GeneratorMemberNode {
    private final ObjectMember element;

    protected GeneratorElementNode(ObjectMember element) {
        super(element.getSourceSection());
        this.element = element;
    }

    @Specialization
    protected void evalDynamic(VmDynamic parent, GeneratorMemberNode.ObjectData data2) {
        this.addElement(data2);
    }

    @Specialization
    protected void evalListing(VmListing parent, GeneratorMemberNode.ObjectData data2) {
        this.addElement(data2);
    }

    @Specialization(guards={"parent == getDynamicClass()"})
    protected void evalDynamicClass(VmClass parent, GeneratorMemberNode.ObjectData data2) {
        this.addElement(data2);
    }

    @Specialization(guards={"parent == getListingClass()"})
    protected void evalListingClass(VmClass parent, GeneratorMemberNode.ObjectData data2) {
        this.addElement(data2);
    }

    @Fallback
    void fallback(Object parent, GeneratorMemberNode.ObjectData data2) {
        CompilerDirectives.transferToInterpreter();
        throw this.exceptionBuilder().evalError("objectCannotHaveElement", parent).build();
    }

    private void addElement(GeneratorMemberNode.ObjectData data2) {
        long index = data2.length;
        EconomicMaps.put(data2.members, index, this.element);
        ++data2.length;
        data2.persistForBindings(index);
    }
}

