/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.ast.expression.generator;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.pkl.core.ast.ExpressionNode;
import org.pkl.core.ast.expression.generator.GeneratorMemberNode;
import org.pkl.core.ast.type.TypeNode;
import org.pkl.core.ast.type.UnresolvedTypeNode;
import org.pkl.core.ast.type.VmTypeMismatchException;
import org.pkl.core.runtime.VmDynamic;
import org.pkl.core.runtime.VmIntSeq;
import org.pkl.core.runtime.VmList;
import org.pkl.core.runtime.VmListing;
import org.pkl.core.runtime.VmMap;
import org.pkl.core.runtime.VmMapping;
import org.pkl.core.runtime.VmObject;
import org.pkl.core.runtime.VmSet;
import org.pkl.core.runtime.VmUtils;
import org.pkl.core.util.LateInit;
import org.pkl.core.util.Nullable;
import org.pkl.core.util.Pair;
import org.pkl.thirdparty.truffle.api.CompilerDirectives;
import org.pkl.thirdparty.truffle.api.dsl.Fallback;
import org.pkl.thirdparty.truffle.api.dsl.Specialization;
import org.pkl.thirdparty.truffle.api.frame.VirtualFrame;
import org.pkl.thirdparty.truffle.api.nodes.ExplodeLoop;
import org.pkl.thirdparty.truffle.api.nodes.Node;
import org.pkl.thirdparty.truffle.api.source.SourceSection;

public abstract class GeneratorForNode
extends GeneratorMemberNode {
    private final int keySlot;
    private final int valueSlot;
    @Node.Child
    private ExpressionNode iterableNode;
    @Node.Child
    @Nullable
    private UnresolvedTypeNode unresolvedKeyTypeNode;
    @Node.Child
    @Nullable
    private UnresolvedTypeNode unresolvedValueTypeNode;
    @Node.Children
    private final GeneratorMemberNode[] childNodes;
    @Node.Child
    @Nullable
    private TypeNode keyTypeNode;
    @Node.Child
    @LateInit
    private TypeNode valueTypeNode;

    public GeneratorForNode(SourceSection sourceSection, int keySlot, int valueSlot, ExpressionNode iterableNode, @Nullable UnresolvedTypeNode unresolvedKeyTypeNode, @Nullable UnresolvedTypeNode unresolvedValueTypeNode, GeneratorMemberNode[] childNodes, boolean hasKeyIdentifier, boolean hasValueIdentifier) {
        super(sourceSection);
        this.keySlot = keySlot;
        this.valueSlot = valueSlot;
        this.iterableNode = iterableNode;
        this.unresolvedKeyTypeNode = unresolvedKeyTypeNode;
        this.unresolvedValueTypeNode = unresolvedValueTypeNode;
        this.childNodes = childNodes;
        if (unresolvedKeyTypeNode == null && hasKeyIdentifier) {
            this.keyTypeNode = new TypeNode.UnknownTypeNode(VmUtils.unavailableSourceSection()).initWriteSlotNode(keySlot);
        }
        if (unresolvedValueTypeNode == null && hasValueIdentifier) {
            this.valueTypeNode = new TypeNode.UnknownTypeNode(VmUtils.unavailableSourceSection()).initWriteSlotNode(valueSlot);
        }
    }

    protected abstract void executeWithIterable(VirtualFrame var1, Object var2, GeneratorMemberNode.ObjectData var3, Object var4);

    @Override
    public final void execute(VirtualFrame frame, Object parent, GeneratorMemberNode.ObjectData data2) {
        this.executeWithIterable(frame, parent, data2, this.iterableNode.executeGeneric(frame));
    }

    @Specialization
    protected void eval(VirtualFrame frame, Object parent, GeneratorMemberNode.ObjectData data2, VmListing iterable) {
        this.doEvalObject(frame, iterable, parent, data2);
    }

    @Specialization
    protected void eval(VirtualFrame frame, Object parent, GeneratorMemberNode.ObjectData data2, VmMapping iterable) {
        this.doEvalObject(frame, iterable, parent, data2);
    }

    @Specialization
    protected void eval(VirtualFrame frame, Object parent, GeneratorMemberNode.ObjectData data2, VmDynamic iterable) {
        this.doEvalObject(frame, iterable, parent, data2);
    }

    @Specialization
    protected void eval(VirtualFrame frame, Object parent, GeneratorMemberNode.ObjectData data2, VmList iterable) {
        this.initTypeNodes(frame);
        long idx = 0L;
        for (Object element : iterable) {
            this.executeIteration(frame, parent, data2, idx++, element);
        }
        this.resetFrameSlots(frame);
    }

    @Specialization
    protected void eval(VirtualFrame frame, Object parent, GeneratorMemberNode.ObjectData data2, VmMap iterable) {
        this.initTypeNodes(frame);
        for (Map.Entry<Object, Object> entry : iterable) {
            this.executeIteration(frame, parent, data2, VmUtils.getKey(entry), VmUtils.getValue(entry));
        }
        this.resetFrameSlots(frame);
    }

    @Specialization
    protected void eval(VirtualFrame frame, Object parent, GeneratorMemberNode.ObjectData data2, VmSet iterable) {
        this.initTypeNodes(frame);
        long idx = 0L;
        for (Object element : iterable) {
            this.executeIteration(frame, parent, data2, idx++, element);
        }
        this.resetFrameSlots(frame);
    }

    @Specialization
    protected void eval(VirtualFrame frame, Object parent, GeneratorMemberNode.ObjectData data2, VmIntSeq iterable) {
        this.initTypeNodes(frame);
        long length2 = iterable.getLength();
        long key2 = 0L;
        long value2 = iterable.start;
        while (key2 < length2) {
            this.executeIteration(frame, parent, data2, key2, value2);
            ++key2;
            value2 += iterable.step;
        }
        this.resetFrameSlots(frame);
    }

    @Fallback
    protected void fallback(VirtualFrame frame, Object parent, GeneratorMemberNode.ObjectData data2, Object iterable) {
        CompilerDirectives.transferToInterpreter();
        throw this.exceptionBuilder().evalError("cannotIterateOverThisValue", VmUtils.getClass(iterable)).withLocation(this.iterableNode).withProgramValue("Value", iterable).build();
    }

    private void doEvalObject(VirtualFrame frame, VmObject iterable, Object parent, GeneratorMemberNode.ObjectData data2) {
        this.initTypeNodes(frame);
        List<Pair<Object, Object>> members2 = this.evaluateMembers(iterable);
        for (int i2 = 0; i2 < members2.size(); ++i2) {
            Pair<Object, Object> member = members2.get(i2);
            this.executeIteration(frame, parent, data2, member.first, member.second);
        }
        this.resetFrameSlots(frame);
    }

    private void resetFrameSlots(VirtualFrame frame) {
        if (this.keySlot != -1) {
            frame.clear(this.keySlot);
        }
        if (this.valueSlot != -1) {
            frame.clear(this.valueSlot);
        }
    }

    private void initTypeNodes(VirtualFrame frame) {
        if (this.unresolvedKeyTypeNode != null) {
            CompilerDirectives.transferToInterpreter();
            this.keyTypeNode = this.insert(this.unresolvedKeyTypeNode.execute(frame)).initWriteSlotNode(this.keySlot);
            this.unresolvedKeyTypeNode = null;
        }
        if (this.unresolvedValueTypeNode != null) {
            CompilerDirectives.transferToInterpreter();
            this.valueTypeNode = this.insert(this.unresolvedValueTypeNode.execute(frame)).initWriteSlotNode(this.valueSlot);
            this.unresolvedValueTypeNode = null;
        }
    }

    @CompilerDirectives.TruffleBoundary
    private List<Pair<Object, Object>> evaluateMembers(VmObject object) {
        ArrayList<Pair<Object, Object>> members2 = new ArrayList<Pair<Object, Object>>();
        object.forceAndIterateMemberValues((key2, member, value2) -> {
            members2.add(Pair.of(member.isProp() ? key2.toString() : key2, value2));
            return true;
        });
        return members2;
    }

    @ExplodeLoop
    private void executeIteration(VirtualFrame frame, Object parent, GeneratorMemberNode.ObjectData data2, Object key2, Object value2) {
        try {
            if (this.keyTypeNode != null) {
                this.keyTypeNode.executeAndSet(frame, key2);
            }
            if (this.valueTypeNode != null) {
                this.valueTypeNode.executeAndSet(frame, value2);
            }
        }
        catch (VmTypeMismatchException e2) {
            CompilerDirectives.transferToInterpreter();
            throw e2.toVmException();
        }
        Object[] prevBindings = null;
        if (this.keyTypeNode != null && this.valueTypeNode != null) {
            prevBindings = data2.addForBinding(key2, value2);
        } else if (this.valueTypeNode != null) {
            prevBindings = data2.addForBinding(value2);
        } else if (this.keyTypeNode != null) {
            prevBindings = data2.addForBinding(key2);
        }
        for (GeneratorMemberNode childNode : this.childNodes) {
            childNode.execute(frame, parent, data2);
        }
        data2.resetForBindings(prevBindings);
    }
}

