/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.ast.expression.generator;

import org.pkl.core.ast.ExpressionNode;
import org.pkl.core.ast.expression.generator.GeneratorMemberNode;
import org.pkl.core.ast.expression.generator.GeneratorObjectLiteralNodeGen;
import org.pkl.core.ast.expression.literal.AmendFunctionNode;
import org.pkl.core.ast.expression.literal.ObjectLiteralNode;
import org.pkl.core.ast.type.UnresolvedTypeNode;
import org.pkl.core.runtime.BaseModule;
import org.pkl.core.runtime.VmClass;
import org.pkl.core.runtime.VmDynamic;
import org.pkl.core.runtime.VmFunction;
import org.pkl.core.runtime.VmLanguage;
import org.pkl.core.runtime.VmListing;
import org.pkl.core.runtime.VmMapping;
import org.pkl.core.runtime.VmNull;
import org.pkl.core.runtime.VmObject;
import org.pkl.core.runtime.VmTyped;
import org.pkl.core.runtime.VmUtils;
import org.pkl.core.util.Nullable;
import org.pkl.thirdparty.truffle.api.CompilerDirectives;
import org.pkl.thirdparty.truffle.api.dsl.Cached;
import org.pkl.thirdparty.truffle.api.dsl.Fallback;
import org.pkl.thirdparty.truffle.api.dsl.Idempotent;
import org.pkl.thirdparty.truffle.api.dsl.ImportStatic;
import org.pkl.thirdparty.truffle.api.dsl.Specialization;
import org.pkl.thirdparty.truffle.api.frame.FrameDescriptor;
import org.pkl.thirdparty.truffle.api.frame.VirtualFrame;
import org.pkl.thirdparty.truffle.api.nodes.ExplodeLoop;
import org.pkl.thirdparty.truffle.api.nodes.Node;
import org.pkl.thirdparty.truffle.api.source.SourceSection;

@ImportStatic(value={BaseModule.class})
public abstract class GeneratorObjectLiteralNode
extends ObjectLiteralNode {
    @Node.Children
    private final GeneratorMemberNode[] memberNodes;

    public GeneratorObjectLiteralNode(SourceSection sourceSection, VmLanguage language, String qualifiedScopeName, boolean isCustomThisScope, @Nullable FrameDescriptor parametersDescriptor, UnresolvedTypeNode[] parameterTypes, GeneratorMemberNode[] memberNodes) {
        super(sourceSection, language, qualifiedScopeName, isCustomThisScope, parametersDescriptor, parameterTypes);
        this.memberNodes = memberNodes;
    }

    @Override
    protected GeneratorObjectLiteralNode copy(ExpressionNode newParentNode) {
        return GeneratorObjectLiteralNodeGen.create(this.sourceSection, this.language, this.qualifiedScopeName, this.isCustomThisScope, null, new UnresolvedTypeNode[0], this.memberNodes, newParentNode);
    }

    @Specialization(guards={"checkObjectCannotHaveParameters()"})
    protected VmDynamic evalDynamic(VirtualFrame frame, VmDynamic parent) {
        GeneratorMemberNode.ObjectData data2 = this.createData(frame, parent, parent.getLength());
        VmDynamic result2 = new VmDynamic(frame.materialize(), (VmObject)parent, data2.members, data2.length);
        result2.setExtraStorage(data2.forBindings);
        return result2;
    }

    @Specialization(guards={"checkObjectCannotHaveParameters()"})
    protected VmTyped evalTyped(VirtualFrame frame, VmTyped parent) {
        VmUtils.checkIsInstantiable(parent.getVmClass(), this.getParentNode());
        GeneratorMemberNode.ObjectData data2 = this.createData(frame, parent, 0);
        assert (data2.forBindings.isEmpty());
        return new VmTyped(frame.materialize(), parent, parent.getVmClass(), data2.members);
    }

    @Specialization(guards={"checkListingCannotHaveParameters()"})
    protected VmListing evalListing(VirtualFrame frame, VmListing parent) {
        GeneratorMemberNode.ObjectData data2 = this.createData(frame, parent, parent.getLength());
        VmListing result2 = new VmListing(frame.materialize(), (VmObject)parent, data2.members, data2.length);
        result2.setExtraStorage(data2.forBindings);
        return result2;
    }

    @Specialization(guards={"checkMappingCannotHaveParameters()"})
    protected VmMapping evalMapping(VirtualFrame frame, VmMapping parent) {
        GeneratorMemberNode.ObjectData data2 = this.createData(frame, parent, 0);
        VmMapping result2 = new VmMapping(frame.materialize(), parent, data2.members);
        result2.setExtraStorage(data2.forBindings);
        return result2;
    }

    @Specialization(guards={"checkObjectCannotHaveParameters()"})
    protected Object evalNull(VirtualFrame frame, VmNull parent) {
        return this.executeWithParent(frame, parent.getDefaultValue());
    }

    @Specialization(guards={"checkIsValidFunctionAmendment(parent)"})
    protected Object evalFunction(VirtualFrame frame, VmFunction parent, @Cached(value="createAmendFunctionNode(frame)", neverDefault=true) AmendFunctionNode amendFunctionNode) {
        return amendFunctionNode.execute(frame, parent);
    }

    @Specialization(guards={"parent == getDynamicClass()", "checkObjectCannotHaveParameters()"})
    protected VmDynamic evalDynamicClass(VirtualFrame frame, VmClass parent) {
        GeneratorMemberNode.ObjectData data2 = this.createData(frame, parent, 0);
        VmDynamic result2 = new VmDynamic(frame.materialize(), (VmObject)parent.getPrototype(), data2.members, data2.length);
        result2.setExtraStorage(data2.forBindings);
        return result2;
    }

    @Specialization(guards={"parent == getMappingClass()", "checkMappingCannotHaveParameters()"})
    protected VmMapping evalMappingClass(VirtualFrame frame, VmClass parent) {
        GeneratorMemberNode.ObjectData data2 = this.createData(frame, parent, 0);
        VmMapping result2 = new VmMapping(frame.materialize(), parent.getPrototype(), data2.members);
        result2.setExtraStorage(data2.forBindings);
        return result2;
    }

    @Specialization(guards={"parent == getListingClass()", "checkListingCannotHaveParameters()"})
    protected VmListing evalListingClass(VirtualFrame frame, VmClass parent) {
        GeneratorMemberNode.ObjectData data2 = this.createData(frame, parent, 0);
        VmListing result2 = new VmListing(frame.materialize(), (VmObject)parent.getPrototype(), data2.members, data2.length);
        result2.setExtraStorage(data2.forBindings);
        return result2;
    }

    @Specialization(guards={"isTypedObjectClass(parent)", "checkObjectCannotHaveParameters()"})
    protected VmTyped evalTypedObjectClass(VirtualFrame frame, VmClass parent) {
        VmUtils.checkIsInstantiable(parent, this.getParentNode());
        GeneratorMemberNode.ObjectData data2 = this.createData(frame, parent, 0);
        assert (data2.forBindings.isEmpty());
        return new VmTyped(frame.materialize(), parent.getPrototype(), parent, data2.members);
    }

    @CompilerDirectives.TruffleBoundary
    @Fallback
    protected void fallback(Object parent) {
        VmClass vmClass;
        VmUtils.checkIsInstantiable(parent instanceof VmClass ? (vmClass = (VmClass)parent) : VmUtils.getClass(parent), this.getParentNode());
        throw this.exceptionBuilder().unreachableCode().build();
    }

    @Idempotent
    protected boolean checkObjectCannotHaveParameters() {
        if (this.parametersDescriptor == null) {
            return true;
        }
        CompilerDirectives.transferToInterpreter();
        throw this.exceptionBuilder().evalError("objectAmendmentCannotHaveParameters", new Object[0]).withLocation(this.parameterTypes[0]).build();
    }

    @Idempotent
    protected boolean checkListingCannotHaveParameters() {
        if (this.parametersDescriptor == null) {
            return true;
        }
        CompilerDirectives.transferToInterpreter();
        throw this.exceptionBuilder().evalError("listingAmendmentCannotHaveParameters", new Object[0]).withLocation(this.parameterTypes[0]).build();
    }

    @Idempotent
    protected boolean checkMappingCannotHaveParameters() {
        if (this.parametersDescriptor == null) {
            return true;
        }
        CompilerDirectives.transferToInterpreter();
        throw this.exceptionBuilder().evalError("mappingAmendmentCannotHaveParameters", new Object[0]).withLocation(this.parameterTypes[0]).build();
    }

    @ExplodeLoop
    private GeneratorMemberNode.ObjectData createData(VirtualFrame frame, Object parent, int parentLength) {
        GeneratorMemberNode.ObjectData data2 = new GeneratorMemberNode.ObjectData(this.memberNodes.length, parentLength);
        for (GeneratorMemberNode memberNode : this.memberNodes) {
            memberNode.execute(frame, parent, data2);
        }
        return data2;
    }
}

