/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.ast.expression.literal;

import org.pkl.core.ast.ExpressionNode;
import org.pkl.core.ast.expression.literal.SpecializedObjectLiteralNode;
import org.pkl.core.ast.member.ObjectMember;
import org.pkl.core.ast.type.UnresolvedTypeNode;
import org.pkl.core.runtime.ModuleInfo;
import org.pkl.core.runtime.VmLanguage;
import org.pkl.core.runtime.VmTyped;
import org.pkl.core.runtime.VmUtils;
import org.pkl.thirdparty.graalvm.collections.EconomicMap;
import org.pkl.thirdparty.truffle.api.CompilerDirectives;
import org.pkl.thirdparty.truffle.api.dsl.Specialization;
import org.pkl.thirdparty.truffle.api.frame.VirtualFrame;
import org.pkl.thirdparty.truffle.api.nodes.Node;
import org.pkl.thirdparty.truffle.api.source.SourceSection;

public abstract class AmendModuleNode
extends SpecializedObjectLiteralNode {
    @Node.Children
    private final ExpressionNode[] annotationNodes;
    private final ModuleInfo moduleInfo;

    public AmendModuleNode(SourceSection sourceSection, VmLanguage language, ExpressionNode[] annotationNodes, EconomicMap<Object, ObjectMember> properties2, ModuleInfo moduleInfo) {
        super(sourceSection, language, "", false, null, new UnresolvedTypeNode[0], properties2);
        this.annotationNodes = annotationNodes;
        this.moduleInfo = moduleInfo;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    protected AmendModuleNode copy(ExpressionNode newParentNode) {
        throw this.exceptionBuilder().unreachableCode().build();
    }

    @Specialization
    protected VmTyped eval(VirtualFrame frame, VmTyped supermodule) {
        VmTyped module = VmUtils.getTypedObjectReceiver(frame);
        if (module == supermodule) {
            CompilerDirectives.transferToInterpreter();
            throw this.exceptionBuilder().evalError("moduleCannotAmendSelf", this.moduleInfo.getModuleName()).build();
        }
        this.checkIsValidTypedAmendment(supermodule);
        module.lateInitVmClass(supermodule.getVmClass());
        module.lateInitParent(supermodule);
        module.addProperties(this.members);
        module.setExtraStorage(this.moduleInfo);
        this.moduleInfo.initAnnotations(VmUtils.evaluateAnnotations(frame, this.annotationNodes));
        return module;
    }
}

