/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.ast.expression.literal;

import org.pkl.core.ast.ExpressionNode;
import org.pkl.core.ast.expression.literal.AmendFunctionNode;
import org.pkl.core.ast.expression.literal.ElementsEntriesLiteralNodeGen;
import org.pkl.core.ast.expression.literal.SpecializedObjectLiteralNode;
import org.pkl.core.ast.member.ObjectMember;
import org.pkl.core.ast.type.UnresolvedTypeNode;
import org.pkl.core.runtime.BaseModule;
import org.pkl.core.runtime.VmClass;
import org.pkl.core.runtime.VmDynamic;
import org.pkl.core.runtime.VmFunction;
import org.pkl.core.runtime.VmLanguage;
import org.pkl.core.runtime.VmListing;
import org.pkl.core.runtime.VmNull;
import org.pkl.core.runtime.VmObject;
import org.pkl.core.util.EconomicMaps;
import org.pkl.core.util.Nullable;
import org.pkl.thirdparty.graalvm.collections.EconomicMap;
import org.pkl.thirdparty.graalvm.collections.UnmodifiableEconomicMap;
import org.pkl.thirdparty.truffle.api.CompilerDirectives;
import org.pkl.thirdparty.truffle.api.dsl.Cached;
import org.pkl.thirdparty.truffle.api.dsl.Fallback;
import org.pkl.thirdparty.truffle.api.dsl.ImportStatic;
import org.pkl.thirdparty.truffle.api.dsl.Specialization;
import org.pkl.thirdparty.truffle.api.frame.FrameDescriptor;
import org.pkl.thirdparty.truffle.api.frame.VirtualFrame;
import org.pkl.thirdparty.truffle.api.nodes.ExplodeLoop;
import org.pkl.thirdparty.truffle.api.nodes.Node;
import org.pkl.thirdparty.truffle.api.source.SourceSection;

@ImportStatic(value={BaseModule.class})
public abstract class ElementsEntriesLiteralNode
extends SpecializedObjectLiteralNode {
    private final ObjectMember[] elements;
    @Node.Children
    private final ExpressionNode[] keyNodes;
    private final ObjectMember[] values;

    public ElementsEntriesLiteralNode(SourceSection sourceSection, VmLanguage language, String qualifiedScopeName, boolean isCustomThisScope, @Nullable FrameDescriptor parametersDescriptor, UnresolvedTypeNode[] parameterTypes, UnmodifiableEconomicMap<Object, ObjectMember> properties2, ObjectMember[] elements, ExpressionNode[] keyNodes, ObjectMember[] values2) {
        super(sourceSection, language, qualifiedScopeName, isCustomThisScope, parametersDescriptor, parameterTypes, properties2);
        this.elements = elements;
        this.keyNodes = keyNodes;
        this.values = values2;
        assert (elements.length > 0);
    }

    @Override
    protected ElementsEntriesLiteralNode copy(ExpressionNode newParentNode) {
        return ElementsEntriesLiteralNodeGen.create(this.sourceSection, this.language, this.qualifiedScopeName, this.isCustomThisScope, null, new UnresolvedTypeNode[0], this.members, this.elements, this.keyNodes, this.values, newParentNode);
    }

    @Specialization(guards={"checkIsValidListingAmendment()"})
    protected VmListing evalListing(VirtualFrame frame, VmListing parent) {
        return new VmListing(frame.materialize(), (VmObject)parent, this.createMembers(frame, parent.getLength()), parent.getLength() + this.elements.length);
    }

    @Specialization
    protected VmDynamic evalDynamic(VirtualFrame frame, VmDynamic parent) {
        return new VmDynamic(frame.materialize(), (VmObject)parent, this.createMembers(frame, parent.getLength()), parent.getLength() + this.elements.length);
    }

    @Specialization
    protected Object evalNull(VirtualFrame frame, VmNull parent) {
        return this.executeWithParent(frame, parent.getDefaultValue());
    }

    @Specialization(guards={"checkIsValidFunctionAmendment(parent)"})
    protected VmFunction evalFunction(VirtualFrame frame, VmFunction parent, @Cached(value="createAmendFunctionNode(frame)", neverDefault=true) AmendFunctionNode amendFunctionNode) {
        return amendFunctionNode.execute(frame, parent);
    }

    @Specialization(guards={"parent == getListingClass()", "checkIsValidListingAmendment()"})
    protected VmListing evalListingClass(VirtualFrame frame, VmClass parent) {
        return new VmListing(frame.materialize(), (VmObject)BaseModule.getListingClass().getPrototype(), this.createMembers(frame, 0), this.elements.length);
    }

    @Specialization(guards={"parent == getDynamicClass()"})
    protected VmDynamic evalDynamicClass(VirtualFrame frame, VmClass parent) {
        return new VmDynamic(frame.materialize(), (VmObject)BaseModule.getDynamicClass().getPrototype(), this.createMembers(frame, 0), this.elements.length);
    }

    @CompilerDirectives.TruffleBoundary
    @Fallback
    protected void fallback(Object parent) {
        this.elementsEntriesFallback(parent, this.elements[0], true);
    }

    @ExplodeLoop
    protected UnmodifiableEconomicMap<Object, ObjectMember> createMembers(VirtualFrame frame, int parentLength) {
        EconomicMap<Object, ObjectMember> result2 = EconomicMaps.create(EconomicMaps.size(this.members) + this.keyNodes.length + this.elements.length);
        EconomicMaps.putAll(result2, this.members);
        this.addListEntries(frame, parentLength, result2, this.keyNodes, this.values);
        for (int i2 = 0; i2 < this.elements.length; ++i2) {
            EconomicMaps.put(result2, Long.valueOf(parentLength + i2), this.elements[i2]);
        }
        return result2;
    }
}

