/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.ast.expression.literal;

import org.pkl.core.ast.ExpressionNode;
import org.pkl.core.ast.expression.literal.AmendFunctionNode;
import org.pkl.core.ast.expression.literal.ElementsLiteralNodeGen;
import org.pkl.core.ast.expression.literal.SpecializedObjectLiteralNode;
import org.pkl.core.ast.member.ObjectMember;
import org.pkl.core.ast.type.UnresolvedTypeNode;
import org.pkl.core.runtime.BaseModule;
import org.pkl.core.runtime.VmClass;
import org.pkl.core.runtime.VmDynamic;
import org.pkl.core.runtime.VmFunction;
import org.pkl.core.runtime.VmLanguage;
import org.pkl.core.runtime.VmListing;
import org.pkl.core.runtime.VmNull;
import org.pkl.core.runtime.VmObject;
import org.pkl.core.util.EconomicMaps;
import org.pkl.core.util.Nullable;
import org.pkl.thirdparty.graalvm.collections.EconomicMap;
import org.pkl.thirdparty.graalvm.collections.UnmodifiableEconomicMap;
import org.pkl.thirdparty.truffle.api.CompilerDirectives;
import org.pkl.thirdparty.truffle.api.dsl.Cached;
import org.pkl.thirdparty.truffle.api.dsl.Fallback;
import org.pkl.thirdparty.truffle.api.dsl.ImportStatic;
import org.pkl.thirdparty.truffle.api.dsl.Specialization;
import org.pkl.thirdparty.truffle.api.frame.FrameDescriptor;
import org.pkl.thirdparty.truffle.api.frame.VirtualFrame;
import org.pkl.thirdparty.truffle.api.source.SourceSection;

@ImportStatic(value={BaseModule.class})
public abstract class ElementsLiteralNode
extends SpecializedObjectLiteralNode {
    private final ObjectMember[] elements;

    public ElementsLiteralNode(SourceSection sourceSection, VmLanguage language, String qualifiedScopeName, boolean isCustomThisScope, @Nullable FrameDescriptor parametersDescriptor, UnresolvedTypeNode[] parameterTypes, UnmodifiableEconomicMap<Object, ObjectMember> properties2, ObjectMember[] elements) {
        super(sourceSection, language, qualifiedScopeName, isCustomThisScope, parametersDescriptor, parameterTypes, properties2);
        this.elements = elements;
        assert (elements.length > 0);
    }

    @Override
    protected ElementsLiteralNode copy(ExpressionNode newParentNode) {
        return ElementsLiteralNodeGen.create(this.sourceSection, this.language, this.qualifiedScopeName, this.isCustomThisScope, null, new UnresolvedTypeNode[0], this.members, this.elements, newParentNode);
    }

    @Specialization(guards={"parent.getLength() == parentLength"})
    protected VmDynamic evalDynamicCached(VirtualFrame frame, VmDynamic parent, @Cached(value="parent.getLength()") int parentLength, @Cached(value="createMembers(parentLength)") UnmodifiableEconomicMap<Object, ObjectMember> members2) {
        return new VmDynamic(frame.materialize(), (VmObject)parent, members2, parentLength + this.elements.length);
    }

    @Specialization
    protected VmDynamic evalDynamicUncached(VirtualFrame frame, VmDynamic parent) {
        return new VmDynamic(frame.materialize(), (VmObject)parent, this.createMembers(parent.getLength()), parent.getLength() + this.elements.length);
    }

    @Specialization
    protected Object evalNull(VirtualFrame frame, VmNull parent) {
        return this.executeWithParent(frame, parent.getDefaultValue());
    }

    @Specialization(guards={"checkIsValidFunctionAmendment(parent)"})
    protected VmFunction evalFunction(VirtualFrame frame, VmFunction parent, @Cached(value="createAmendFunctionNode(frame)", neverDefault=true) AmendFunctionNode amendFunctionNode) {
        return amendFunctionNode.execute(frame, parent);
    }

    @Specialization(guards={"parent == getListingClass()", "checkIsValidListingAmendment()", "checkMaxListingMemberIndex(0)"})
    protected VmListing evalListingClass(VirtualFrame frame, VmClass parent, @Cached(value="createMembers(0)", neverDefault=true) UnmodifiableEconomicMap<Object, ObjectMember> members2) {
        return new VmListing(frame.materialize(), (VmObject)BaseModule.getListingClass().getPrototype(), members2, this.elements.length);
    }

    @Specialization(guards={"parent == getDynamicClass()"})
    protected VmDynamic evalDynamicClass(VirtualFrame frame, VmClass parent, @Cached(value="createMembers(0)", neverDefault=true) UnmodifiableEconomicMap<Object, ObjectMember> members2) {
        return new VmDynamic(frame.materialize(), (VmObject)BaseModule.getDynamicClass().getPrototype(), members2, this.elements.length);
    }

    @Specialization(guards={"checkIsValidListingAmendment()", "parent.getLength() == parentLength", "checkMaxListingMemberIndex(parentLength)"})
    protected VmListing evalListingCached(VirtualFrame frame, VmListing parent, @Cached(value="parent.getLength()") int parentLength, @Cached(value="createMembers(parentLength)") UnmodifiableEconomicMap<Object, ObjectMember> properties2) {
        return new VmListing(frame.materialize(), (VmObject)parent, properties2, parentLength + this.elements.length);
    }

    @Specialization(guards={"checkIsValidListingAmendment()"})
    protected VmListing evalListingUncached(VirtualFrame frame, VmListing parent) {
        this.checkMaxListingMemberIndex(parent.getLength());
        return new VmListing(frame.materialize(), (VmObject)parent, this.createMembers(parent.getLength()), parent.getLength() + this.elements.length);
    }

    @CompilerDirectives.TruffleBoundary
    @Fallback
    protected void fallback(Object parent) {
        this.elementsEntriesFallback(parent, this.elements[0], true);
    }

    protected UnmodifiableEconomicMap<Object, ObjectMember> createMembers(int parentLength) {
        EconomicMap<Object, ObjectMember> result2 = EconomicMaps.create(EconomicMaps.size(this.members) + this.elements.length);
        EconomicMaps.putAll(result2, this.members);
        for (int i2 = 0; i2 < this.elements.length; ++i2) {
            EconomicMaps.put(result2, Long.valueOf(parentLength + i2), this.elements[i2]);
        }
        return result2;
    }
}

