/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.ast.expression.literal;

import org.pkl.core.ast.ExpressionNode;
import org.pkl.core.ast.builder.SymbolTable;
import org.pkl.core.ast.member.FunctionNode;
import org.pkl.core.ast.member.UnresolvedFunctionNode;
import org.pkl.core.runtime.VmFunction;
import org.pkl.core.runtime.VmUtils;
import org.pkl.core.util.Nullable;
import org.pkl.thirdparty.truffle.api.CompilerDirectives;
import org.pkl.thirdparty.truffle.api.frame.VirtualFrame;
import org.pkl.thirdparty.truffle.api.nodes.Node;
import org.pkl.thirdparty.truffle.api.source.SourceSection;

public final class FunctionLiteralNode
extends ExpressionNode {
    @Node.Child
    private UnresolvedFunctionNode unresolvedFunctionNode;
    private final boolean isCustomThisScope;
    @CompilerDirectives.CompilationFinal
    @Nullable
    private FunctionNode functionNode;
    @CompilerDirectives.CompilationFinal
    private int customThisSlot = -1;

    public FunctionLiteralNode(SourceSection sourceSection, UnresolvedFunctionNode functionNode, boolean isCustomThisScope) {
        super(sourceSection);
        this.unresolvedFunctionNode = functionNode;
        this.isCustomThisScope = isCustomThisScope;
    }

    @Override
    public VmFunction executeGeneric(VirtualFrame frame) {
        if (this.functionNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.functionNode = this.unresolvedFunctionNode.execute(frame);
            if (this.isCustomThisScope) {
                this.customThisSlot = VmUtils.findAuxiliarySlot(frame, SymbolTable.CustomThisScope.FRAME_SLOT_ID);
            }
        }
        return new VmFunction(frame.materialize(), this.isCustomThisScope ? frame.getAuxiliarySlot(this.customThisSlot) : VmUtils.getReceiver(frame), this.functionNode.getParameterCount(), this.functionNode, null);
    }
}

