/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.ast.expression.member;

import org.pkl.core.ast.ExpressionNode;
import org.pkl.core.ast.member.ObjectMember;
import org.pkl.core.ast.member.ObjectMethodNode;
import org.pkl.core.ast.type.TypeNode;
import org.pkl.core.runtime.Identifier;
import org.pkl.core.runtime.VmDynamic;
import org.pkl.core.runtime.VmLanguage;
import org.pkl.core.runtime.VmObjectLike;
import org.pkl.core.util.LateInit;
import org.pkl.thirdparty.truffle.api.CompilerDirectives;
import org.pkl.thirdparty.truffle.api.frame.VirtualFrame;
import org.pkl.thirdparty.truffle.api.nodes.Node;
import org.pkl.thirdparty.truffle.api.source.SourceSection;

public final class InferParentWithinObjectMethodNode
extends ExpressionNode {
    private final VmLanguage language;
    private final Identifier localMethodName;
    @Node.Child
    private ExpressionNode ownerNode;
    @CompilerDirectives.CompilationFinal
    @LateInit
    private Object inferredParent;

    public InferParentWithinObjectMethodNode(SourceSection sourceSection, VmLanguage language, Identifier localMethodName, ExpressionNode ownerNode) {
        super(sourceSection);
        this.language = language;
        this.localMethodName = localMethodName;
        this.ownerNode = ownerNode;
        assert (localMethodName.isLocalMethod());
    }

    @Override
    public Object executeGeneric(VirtualFrame frame) {
        if (this.inferredParent != null) {
            return this.inferredParent;
        }
        CompilerDirectives.transferToInterpreter();
        VmObjectLike owner = (VmObjectLike)this.ownerNode.executeGeneric(frame);
        ObjectMember member = owner.getMember(this.localMethodName);
        assert (member != null);
        ObjectMethodNode methodNode = (ObjectMethodNode)member.getMemberNode();
        assert (methodNode != null);
        TypeNode returnTypeNode = methodNode.getReturnTypeNode();
        if (returnTypeNode == null || returnTypeNode instanceof TypeNode.UnknownTypeNode) {
            this.inferredParent = VmDynamic.empty();
            this.ownerNode = null;
            return this.inferredParent;
        }
        Object defaultReturnTypeValue = returnTypeNode.createDefaultValue(this.language, member.getHeaderSection(), member.getQualifiedName());
        if (defaultReturnTypeValue != null) {
            this.inferredParent = defaultReturnTypeValue;
            this.ownerNode = null;
            return this.inferredParent;
        }
        throw this.exceptionBuilder().evalError("cannotInferParent", new Object[0]).build();
    }
}

