/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.ast.expression.member;

import org.pkl.core.ast.ExpressionNode;
import org.pkl.core.ast.member.ClassProperty;
import org.pkl.core.ast.member.ObjectMember;
import org.pkl.core.ast.member.PropertyTypeNode;
import org.pkl.core.runtime.BaseModule;
import org.pkl.core.runtime.Identifier;
import org.pkl.core.runtime.VmDynamic;
import org.pkl.core.runtime.VmListing;
import org.pkl.core.runtime.VmMapping;
import org.pkl.core.runtime.VmObjectLike;
import org.pkl.core.runtime.VmTyped;
import org.pkl.core.runtime.VmUndefinedValueException;
import org.pkl.core.runtime.VmUtils;
import org.pkl.thirdparty.truffle.api.CompilerDirectives;
import org.pkl.thirdparty.truffle.api.dsl.NodeChild;
import org.pkl.thirdparty.truffle.api.dsl.Specialization;
import org.pkl.thirdparty.truffle.api.source.SourceSection;

@NodeChild(value="ownerNode", type=ExpressionNode.class)
public abstract class InferParentWithinPropertyNode
extends ExpressionNode {
    private final Identifier ownPropertyName;
    private final boolean isLocalProperty;

    protected InferParentWithinPropertyNode(SourceSection sourceSection, Identifier ownPropertyName) {
        super(sourceSection);
        this.ownPropertyName = ownPropertyName;
        this.isLocalProperty = ownPropertyName.isLocalProp();
    }

    @Specialization(guards={"!owner.isPrototype()"})
    protected Object evalTypedObject(VmTyped owner) {
        if (this.isLocalProperty) {
            return this.getLocalPropertyDefaultValue(owner);
        }
        try {
            Object result2 = VmUtils.readMemberOrNull((VmObjectLike)owner.getPrototype(), (Object)this.ownPropertyName, false);
            assert (result2 != null) : "every property has a default";
            return result2;
        }
        catch (VmUndefinedValueException e2) {
            CompilerDirectives.transferToInterpreter();
            throw this.exceptionBuilder().evalError("cannotInferParent", new Object[0]).build();
        }
    }

    @Specialization(guards={"owner.isPrototype()"})
    protected Object evalPrototype(VmTyped owner) {
        ClassProperty property;
        ClassProperty classProperty = property = this.isLocalProperty ? owner.getVmClass().getDeclaredProperty(this.ownPropertyName) : owner.getVmClass().getProperty(this.ownPropertyName);
        assert (property != null);
        PropertyTypeNode typeNode = property.getTypeNode();
        if (typeNode == null || typeNode.isUnknownType()) {
            return VmDynamic.empty();
        }
        Object result2 = typeNode.getDefaultValue();
        if (result2 != null) {
            return result2;
        }
        CompilerDirectives.transferToInterpreter();
        throw this.exceptionBuilder().evalError("cannotInferParent", new Object[0]).build();
    }

    @Specialization
    protected Object eval(VmDynamic owner) {
        if (this.isLocalProperty) {
            return this.getLocalPropertyDefaultValue(owner);
        }
        return VmDynamic.empty();
    }

    @Specialization
    protected Object eval(VmListing owner) {
        if (this.isLocalProperty) {
            return this.getLocalPropertyDefaultValue(owner);
        }
        assert (this.ownPropertyName == Identifier.DEFAULT);
        return VmUtils.readMember(BaseModule.getListingClass().getPrototype(), this.ownPropertyName);
    }

    @Specialization
    protected Object eval(VmMapping owner) {
        if (this.isLocalProperty) {
            return this.getLocalPropertyDefaultValue(owner);
        }
        assert (this.ownPropertyName == Identifier.DEFAULT);
        return VmUtils.readMember(BaseModule.getMappingClass().getPrototype(), this.ownPropertyName);
    }

    private Object getLocalPropertyDefaultValue(VmObjectLike owner) {
        assert (this.isLocalProperty);
        ObjectMember member = owner.getMember(this.ownPropertyName);
        assert (member != null);
        Object defaultValue = member.getLocalPropertyDefaultValue();
        if (defaultValue != null) {
            return defaultValue;
        }
        CompilerDirectives.transferToInterpreter();
        throw this.exceptionBuilder().evalError("cannotInferParent", new Object[0]).build();
    }
}

