/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.ast.expression.member;

import org.pkl.core.ast.ExpressionNode;
import org.pkl.core.ast.member.ClassMethod;
import org.pkl.core.runtime.VmObjectLike;
import org.pkl.thirdparty.truffle.api.frame.VirtualFrame;
import org.pkl.thirdparty.truffle.api.nodes.DirectCallNode;
import org.pkl.thirdparty.truffle.api.nodes.ExplodeLoop;
import org.pkl.thirdparty.truffle.api.nodes.Node;
import org.pkl.thirdparty.truffle.api.source.SourceSection;

public final class InvokeMethodDirectNode
extends ExpressionNode {
    private final VmObjectLike owner;
    @Node.Child
    private ExpressionNode receiverNode;
    @Node.Children
    private final ExpressionNode[] argumentNodes;
    @Node.Child
    private DirectCallNode callNode;

    public InvokeMethodDirectNode(SourceSection sourceSection, ClassMethod method, ExpressionNode receiverNode, ExpressionNode[] argumentNodes) {
        super(sourceSection);
        this.owner = method.getOwner();
        this.receiverNode = receiverNode;
        this.argumentNodes = argumentNodes;
        this.callNode = DirectCallNode.create(method.getCallTarget(sourceSection));
    }

    @Override
    @ExplodeLoop
    public Object executeGeneric(VirtualFrame frame) {
        Object[] args2 = new Object[2 + this.argumentNodes.length];
        args2[0] = this.receiverNode.executeGeneric(frame);
        args2[1] = this.owner;
        for (int i2 = 0; i2 < this.argumentNodes.length; ++i2) {
            args2[2 + i2] = this.argumentNodes[i2].executeGeneric(frame);
        }
        return this.callNode.call(args2);
    }
}

