/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.ast.expression.member;

import org.pkl.core.ast.ExpressionNode;
import org.pkl.core.runtime.VmObjectLike;
import org.pkl.core.runtime.VmUtils;
import org.pkl.thirdparty.truffle.api.CallTarget;
import org.pkl.thirdparty.truffle.api.frame.Frame;
import org.pkl.thirdparty.truffle.api.frame.VirtualFrame;
import org.pkl.thirdparty.truffle.api.nodes.DirectCallNode;
import org.pkl.thirdparty.truffle.api.nodes.ExplodeLoop;
import org.pkl.thirdparty.truffle.api.nodes.Node;
import org.pkl.thirdparty.truffle.api.source.SourceSection;

public final class InvokeMethodLexicalNode
extends ExpressionNode {
    @Node.Children
    private final ExpressionNode[] argumentNodes;
    private final int levelsUp;
    @Node.Child
    private DirectCallNode callNode;

    InvokeMethodLexicalNode(SourceSection sourceSection, CallTarget callTarget, int levelsUp, ExpressionNode[] argumentNodes) {
        super(sourceSection);
        this.levelsUp = levelsUp;
        this.argumentNodes = argumentNodes;
        this.callNode = DirectCallNode.create(callTarget);
    }

    @Override
    @ExplodeLoop
    public Object executeGeneric(VirtualFrame frame) {
        Object[] args2 = new Object[2 + this.argumentNodes.length];
        Frame enclosingFrame = this.getEnclosingFrame(frame);
        args2[0] = VmUtils.getReceiver(enclosingFrame);
        args2[1] = VmUtils.getOwner(enclosingFrame);
        for (int i2 = 0; i2 < this.argumentNodes.length; ++i2) {
            args2[2 + i2] = this.argumentNodes[i2].executeGeneric(frame);
        }
        return this.callNode.call(args2);
    }

    @ExplodeLoop
    private Frame getEnclosingFrame(VirtualFrame frame) {
        if (this.levelsUp == 0) {
            return frame;
        }
        VmObjectLike owner = VmUtils.getOwner(frame);
        for (int i2 = 1; i2 < this.levelsUp; ++i2) {
            owner = owner.getEnclosingOwner();
            assert (owner != null);
        }
        return owner.getEnclosingFrame();
    }
}

