/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.ast.expression.member;

import org.pkl.core.ast.ExpressionNode;
import org.pkl.core.ast.MemberLookupMode;
import org.pkl.core.ast.internal.GetClassNode;
import org.pkl.core.ast.member.ClassMethod;
import org.pkl.core.runtime.Identifier;
import org.pkl.core.runtime.VmClass;
import org.pkl.core.runtime.VmFunction;
import org.pkl.thirdparty.truffle.api.CompilerDirectives;
import org.pkl.thirdparty.truffle.api.RootCallTarget;
import org.pkl.thirdparty.truffle.api.dsl.Cached;
import org.pkl.thirdparty.truffle.api.dsl.ImportStatic;
import org.pkl.thirdparty.truffle.api.dsl.NodeChild;
import org.pkl.thirdparty.truffle.api.dsl.NodeChildren;
import org.pkl.thirdparty.truffle.api.dsl.Specialization;
import org.pkl.thirdparty.truffle.api.frame.VirtualFrame;
import org.pkl.thirdparty.truffle.api.nodes.DirectCallNode;
import org.pkl.thirdparty.truffle.api.nodes.ExplodeLoop;
import org.pkl.thirdparty.truffle.api.nodes.IndirectCallNode;
import org.pkl.thirdparty.truffle.api.nodes.Node;
import org.pkl.thirdparty.truffle.api.source.SourceSection;

@ImportStatic(value={Identifier.class})
@NodeChildren(value={@NodeChild(value="receiverNode", type=ExpressionNode.class), @NodeChild(value="receiverClassNode", type=GetClassNode.class, executeWith={"receiverNode"})})
public abstract class InvokeMethodVirtualNode
extends ExpressionNode {
    protected final Identifier methodName;
    @Node.Children
    private final ExpressionNode[] argumentNodes;
    private final MemberLookupMode lookupMode;
    private final boolean needsConst;

    protected InvokeMethodVirtualNode(SourceSection sourceSection, Identifier methodName, ExpressionNode[] argumentNodes, MemberLookupMode lookupMode, boolean needsConst) {
        super(sourceSection);
        this.methodName = methodName;
        this.argumentNodes = argumentNodes;
        this.lookupMode = lookupMode;
        this.needsConst = needsConst;
    }

    protected InvokeMethodVirtualNode(SourceSection sourceSection, Identifier methodName, ExpressionNode[] argumentNodes, MemberLookupMode lookupMode) {
        this(sourceSection, methodName, argumentNodes, lookupMode, false);
    }

    public abstract Object executeWith(VirtualFrame var1, Object var2, VmClass var3);

    @ExplodeLoop
    @Specialization(guards={"methodName == APPLY", "receiver.getCallTarget() == cachedCallTarget"})
    protected Object evalFunctionCached(VirtualFrame frame, VmFunction receiver, VmClass receiverClass, @Cached(value="receiver.getCallTarget()") RootCallTarget cachedCallTarget, @Cached(value="create(cachedCallTarget)") DirectCallNode callNode) {
        Object[] args2 = new Object[2 + this.argumentNodes.length];
        args2[0] = receiver.getThisValue();
        args2[1] = receiver;
        for (int i2 = 0; i2 < this.argumentNodes.length; ++i2) {
            args2[2 + i2] = this.argumentNodes[i2].executeGeneric(frame);
        }
        return callNode.call(args2);
    }

    @ExplodeLoop
    @Specialization(guards={"methodName == APPLY"}, replaces={"evalFunctionCached"})
    protected Object evalFunction(VirtualFrame frame, VmFunction receiver, VmClass receiverClass, @Cached.Exclusive @Cached(value="create()") IndirectCallNode callNode) {
        Object[] args2 = new Object[2 + this.argumentNodes.length];
        args2[0] = receiver.getThisValue();
        args2[1] = receiver;
        for (int i2 = 0; i2 < this.argumentNodes.length; ++i2) {
            args2[2 + i2] = this.argumentNodes[i2].executeGeneric(frame);
        }
        return callNode.call(receiver.getCallTarget(), args2);
    }

    @ExplodeLoop
    @Specialization(guards={"receiverClass == cachedReceiverClass"})
    protected Object evalCached(VirtualFrame frame, Object receiver, VmClass receiverClass, @Cached(value="receiverClass") VmClass cachedReceiverClass, @Cached(value="resolveMethod(receiverClass)") ClassMethod method, @Cached(value="create(method.getCallTarget(sourceSection))") DirectCallNode callNode) {
        Object[] args2 = new Object[2 + this.argumentNodes.length];
        args2[0] = receiver;
        args2[1] = method.getOwner();
        for (int i2 = 0; i2 < this.argumentNodes.length; ++i2) {
            args2[2 + i2] = this.argumentNodes[i2].executeGeneric(frame);
        }
        return callNode.call(args2);
    }

    @ExplodeLoop
    @Specialization(replaces={"evalCached"})
    protected Object eval(VirtualFrame frame, Object receiver, VmClass receiverClass, @Cached.Exclusive @Cached(value="create()") IndirectCallNode callNode) {
        ClassMethod method = this.resolveMethod(receiverClass);
        Object[] args2 = new Object[2 + this.argumentNodes.length];
        args2[0] = receiver;
        args2[1] = method.getOwner();
        for (int i2 = 0; i2 < this.argumentNodes.length; ++i2) {
            args2[2 + i2] = this.argumentNodes[i2].executeGeneric(frame);
        }
        return callNode.call(method.getCallTarget(), args2);
    }

    protected ClassMethod resolveMethod(VmClass receiverClass) {
        ClassMethod method = receiverClass.getMethod(this.methodName);
        if (method != null) {
            this.checkConst(method);
            return method;
        }
        CompilerDirectives.transferToInterpreter();
        throw this.exceptionBuilder().cannotFindMethod(receiverClass.getPrototype(), this.methodName, this.argumentNodes.length, this.lookupMode != MemberLookupMode.EXPLICIT_RECEIVER).build();
    }

    private void checkConst(ClassMethod method) {
        if (this.needsConst && !method.isConst()) {
            CompilerDirectives.transferToInterpreter();
            throw this.exceptionBuilder().evalError("methodMustBeConst", this.methodName.toString()).build();
        }
    }
}

