/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.ast.expression.member;

import org.pkl.core.ast.ExpressionNode;
import org.pkl.core.ast.member.ObjectMember;
import org.pkl.core.runtime.Identifier;
import org.pkl.core.runtime.VmFunction;
import org.pkl.core.runtime.VmObjectLike;
import org.pkl.core.runtime.VmUtils;
import org.pkl.thirdparty.truffle.api.frame.VirtualFrame;
import org.pkl.thirdparty.truffle.api.nodes.IndirectCallNode;
import org.pkl.thirdparty.truffle.api.nodes.Node;
import org.pkl.thirdparty.truffle.api.source.SourceSection;

public class ReadSuperEntryNode
extends ExpressionNode {
    @Node.Child
    private ExpressionNode keyNode;
    @Node.Child
    private IndirectCallNode callNode = IndirectCallNode.create();

    public ReadSuperEntryNode(SourceSection sourceSection, ExpressionNode keyNode) {
        super(sourceSection);
        this.keyNode = keyNode;
    }

    @Override
    public Object executeGeneric(VirtualFrame frame) {
        Object key2 = this.keyNode.executeGeneric(frame);
        VmObjectLike receiver = VmUtils.getObjectReceiver(frame);
        VmObjectLike initialOwner = VmUtils.getOwner(frame);
        while (initialOwner instanceof VmFunction) {
            initialOwner = initialOwner.getEnclosingOwner();
        }
        assert (initialOwner != null) : "VmFunction always has a parent";
        for (VmObjectLike owner = initialOwner = initialOwner.getParent(); owner != null; owner = owner.getParent()) {
            ObjectMember member = owner.getMember(key2);
            if (member == null) continue;
            Object constantValue = member.getConstantValue();
            if (constantValue != null) {
                return constantValue;
            }
            return this.callNode.call(member.getCallTarget(), receiver, owner, key2, VmUtils.SKIP_TYPECHECK_MARKER);
        }
        VmFunction defaultFunction = (VmFunction)VmUtils.readMemberOrNull(receiver, (Object)Identifier.DEFAULT, this.callNode);
        assert (defaultFunction != null);
        return defaultFunction.apply(key2);
    }
}

