/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.ast.expression.unary;

import java.net.URI;
import java.util.Map;
import org.pkl.core.SecurityManagerException;
import org.pkl.core.ast.ExpressionNode;
import org.pkl.core.http.HttpClientInitException;
import org.pkl.core.module.ModuleKey;
import org.pkl.core.module.ResolvedModuleKey;
import org.pkl.core.packages.PackageLoadError;
import org.pkl.core.runtime.VmContext;
import org.pkl.core.runtime.VmLanguage;
import org.pkl.core.runtime.VmObjectLike;
import org.pkl.core.runtime.VmTyped;
import org.pkl.core.runtime.VmUtils;
import org.pkl.core.util.GlobResolver;
import org.pkl.thirdparty.truffle.api.CompilerDirectives;
import org.pkl.thirdparty.truffle.api.frame.VirtualFrame;
import org.pkl.thirdparty.truffle.api.source.SourceSection;

public final class ImportGlobMemberBodyNode
extends ExpressionNode {
    private final VmLanguage language;
    private final ResolvedModuleKey currentModule;

    public ImportGlobMemberBodyNode(SourceSection sourceSection, VmLanguage language, ResolvedModuleKey currentModule) {
        super(sourceSection);
        this.language = language;
        this.currentModule = currentModule;
    }

    @Override
    public Object executeGeneric(VirtualFrame frame) {
        VmObjectLike mapping = VmUtils.getOwner(frame);
        String path2 = (String)VmUtils.getMemberKey(frame);
        return this.importModule(mapping, path2);
    }

    @CompilerDirectives.TruffleBoundary
    private VmTyped importModule(VmObjectLike mapping, String path2) {
        Map globElements = (Map)mapping.getExtraStorage();
        URI importUri = ((GlobResolver.ResolvedGlobElement)globElements.get(path2)).getUri();
        VmContext context2 = VmContext.get(this);
        try {
            context2.getSecurityManager().checkImportModule(this.currentModule.getUri(), importUri);
            ModuleKey moduleToImport = context2.getModuleResolver().resolve(importUri, this);
            return this.language.loadModule(moduleToImport, this);
        }
        catch (SecurityManagerException | HttpClientInitException | PackageLoadError e2) {
            throw this.exceptionBuilder().withCause(e2).build();
        }
    }
}

