/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.ast.expression.unary;

import org.pkl.core.ast.ExpressionNode;
import org.pkl.core.runtime.VmContext;
import org.pkl.core.runtime.VmException;
import org.pkl.core.runtime.VmObjectLike;
import org.pkl.core.runtime.VmUtils;
import org.pkl.core.runtime.VmValueRenderer;
import org.pkl.thirdparty.truffle.api.CompilerDirectives;
import org.pkl.thirdparty.truffle.api.frame.VirtualFrame;
import org.pkl.thirdparty.truffle.api.nodes.Node;
import org.pkl.thirdparty.truffle.api.source.SourceSection;

public final class TraceNode
extends ExpressionNode {
    @Node.Child
    private ExpressionNode valueNode;
    private final VmValueRenderer renderer = VmValueRenderer.singleLine(1000000);

    public TraceNode(SourceSection sourceSection, ExpressionNode valueNode) {
        super(sourceSection);
        this.valueNode = valueNode;
    }

    @Override
    public Object executeGeneric(VirtualFrame frame) {
        Object value2 = this.valueNode.executeGeneric(frame);
        this.doTrace(value2, VmContext.get(this));
        return value2;
    }

    @CompilerDirectives.TruffleBoundary
    private void doTrace(Object value2, VmContext context2) {
        if (value2 instanceof VmObjectLike) {
            VmObjectLike objectLike = (VmObjectLike)value2;
            try {
                objectLike.force(true, true);
            }
            catch (VmException vmException) {
                // empty catch block
            }
        }
        SourceSection sourceSection = this.valueNode.getSourceSection();
        String renderedValue = this.renderer.render(value2);
        String message = (sourceSection.isAvailable() ? sourceSection.getCharacters() : "<value") + " = " + renderedValue;
        context2.getLogger().trace(message, VmUtils.createStackFrame(sourceSection, null));
    }
}

