/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.ast.member;

import java.util.List;
import org.pkl.core.Logger;
import org.pkl.core.PClass;
import org.pkl.core.TypeParameter;
import org.pkl.core.ast.VmModifier;
import org.pkl.core.ast.member.ClassMember;
import org.pkl.core.ast.member.FunctionNode;
import org.pkl.core.ast.type.TypeNode;
import org.pkl.core.runtime.Identifier;
import org.pkl.core.runtime.MirrorFactories;
import org.pkl.core.runtime.VmCollection;
import org.pkl.core.runtime.VmContext;
import org.pkl.core.runtime.VmList;
import org.pkl.core.runtime.VmMap;
import org.pkl.core.runtime.VmSet;
import org.pkl.core.runtime.VmTyped;
import org.pkl.core.runtime.VmUtils;
import org.pkl.core.util.Nullable;
import org.pkl.thirdparty.truffle.api.CallTarget;
import org.pkl.thirdparty.truffle.api.CompilerDirectives;
import org.pkl.thirdparty.truffle.api.source.SourceSection;

public final class ClassMethod
extends ClassMember {
    private final List<TypeParameter> typeParameters;
    @Nullable
    private final String deprecation;
    @CompilerDirectives.CompilationFinal
    private FunctionNode functionNode;

    public ClassMethod(SourceSection sourceSection, SourceSection headerSection, int modifiers, Identifier name, String qualifiedName2, @Nullable SourceSection docComment, List<VmTyped> annotations2, VmTyped owner, List<TypeParameter> typeParameters2, @Nullable String deprecation) {
        super(sourceSection, headerSection, modifiers, name, qualifiedName2, docComment, annotations2, owner);
        this.typeParameters = typeParameters2;
        this.deprecation = deprecation;
    }

    public void initFunctionNode(FunctionNode functionNode) {
        assert (this.functionNode == null);
        this.functionNode = functionNode;
    }

    public CallTarget getCallTarget() {
        return this.functionNode.getCallTarget();
    }

    @CompilerDirectives.TruffleBoundary
    private void reportDeprecation(SourceSection callSite) {
        assert (this.deprecation != null);
        Logger logger = VmContext.get(null).getLogger();
        logger.warn("Method `" + this.qualifiedName + "` is deprecated" + (String)(this.deprecation.isEmpty() ? "" : ": " + this.deprecation), VmUtils.createStackFrame(callSite, null));
    }

    public CallTarget getCallTarget(SourceSection callSite) {
        if (this.deprecation != null) {
            this.reportDeprecation(callSite);
        }
        return this.functionNode.getCallTarget();
    }

    public int getParameterCount() {
        return this.functionNode.getParameterCount();
    }

    @Nullable
    public TypeNode getReturnTypeNode() {
        return this.functionNode.getReturnTypeNode();
    }

    @Override
    public String getCallSignature() {
        return this.functionNode.getCallSignature();
    }

    public VmTyped getMirror() {
        return MirrorFactories.methodFactory.create(this);
    }

    public VmSet getModifierMirrors() {
        return VmModifier.getMirrors(this.modifiers, false);
    }

    public VmList getTypeParameterMirrors() {
        VmCollection.Builder<VmList> builder = VmList.EMPTY.builder();
        for (TypeParameter typeParameter : this.typeParameters) {
            builder.add(MirrorFactories.typeParameterFactory.create(typeParameter));
        }
        return builder.build();
    }

    public VmMap getParameterMirrors() {
        return this.functionNode.getParameterMirrors();
    }

    public VmTyped getReturnTypeMirror() {
        return this.functionNode.getReturnTypeMirror();
    }

    public PClass.Method export(PClass owner) {
        return this.functionNode.export(owner, this.docComment, this.annotations, this.modifiers, this.typeParameters);
    }
}

