/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.ast.member;

import java.util.LinkedHashMap;
import java.util.List;
import org.pkl.core.Member;
import org.pkl.core.PClass;
import org.pkl.core.PType;
import org.pkl.core.TypeParameter;
import org.pkl.core.ast.ExpressionNode;
import org.pkl.core.ast.VmModifier;
import org.pkl.core.ast.member.ClassMethod;
import org.pkl.core.ast.member.Lambda;
import org.pkl.core.ast.member.Member;
import org.pkl.core.ast.member.ObjectMember;
import org.pkl.core.ast.member.RegularMemberNode;
import org.pkl.core.ast.type.TypeNode;
import org.pkl.core.ast.type.VmTypeMismatchException;
import org.pkl.core.runtime.MirrorFactories;
import org.pkl.core.runtime.VmException;
import org.pkl.core.runtime.VmLanguage;
import org.pkl.core.runtime.VmMap;
import org.pkl.core.runtime.VmStackOverflowException;
import org.pkl.core.runtime.VmTyped;
import org.pkl.core.runtime.VmUtils;
import org.pkl.core.util.CollectionUtils;
import org.pkl.core.util.Nullable;
import org.pkl.core.util.Pair;
import org.pkl.thirdparty.truffle.api.CompilerDirectives;
import org.pkl.thirdparty.truffle.api.frame.FrameDescriptor;
import org.pkl.thirdparty.truffle.api.frame.VirtualFrame;
import org.pkl.thirdparty.truffle.api.nodes.ExplodeLoop;
import org.pkl.thirdparty.truffle.api.nodes.Node;
import org.pkl.thirdparty.truffle.api.source.SourceSection;

public final class FunctionNode
extends RegularMemberNode {
    private static final int IMPLICIT_PARAM_COUNT = 2;
    private final int paramCount;
    private final int totalParamCount;
    @Node.Children
    private final TypeNode[] parameterTypeNodes;
    @Node.Child
    @Nullable
    private TypeNode checkedReturnTypeNode;
    @Nullable
    private TypeNode returnTypeNode;

    @CompilerDirectives.TruffleBoundary
    public FunctionNode(VmLanguage language, FrameDescriptor descriptor2, Member member, int paramCount, TypeNode[] parameterTypeNodes, @Nullable TypeNode returnTypeNode, boolean isReturnTypeChecked, ExpressionNode bodyNode) {
        super(language, descriptor2, member, bodyNode);
        assert (member instanceof ClassMethod || member instanceof ObjectMember || member instanceof Lambda);
        this.paramCount = paramCount;
        this.parameterTypeNodes = parameterTypeNodes;
        this.checkedReturnTypeNode = isReturnTypeChecked ? returnTypeNode : null;
        this.returnTypeNode = returnTypeNode;
        this.totalParamCount = Math.addExact(2, paramCount);
    }

    public int getParameterCount() {
        return this.paramCount;
    }

    @Nullable
    public TypeNode getReturnTypeNode() {
        return this.returnTypeNode;
    }

    @CompilerDirectives.TruffleBoundary
    public String getCallSignature() {
        StringBuilder sb = new StringBuilder(this.member.getName().toString());
        sb.append('(');
        for (int i2 = 0; i2 < Math.min(this.getFrameDescriptor().getNumberOfSlots(), this.paramCount); ++i2) {
            if (i2 > 0) {
                sb.append(", ");
            }
            sb.append(this.getFrameDescriptor().getSlotName(i2));
        }
        sb.append(')');
        return sb.toString();
    }

    @Override
    @ExplodeLoop
    public Object execute(VirtualFrame frame) {
        int totalArgCount = frame.getArguments().length;
        if (totalArgCount != this.totalParamCount) {
            CompilerDirectives.transferToInterpreter();
            throw this.wrongArgumentCount(totalArgCount - 2);
        }
        try {
            for (int i2 = 0; i2 < this.parameterTypeNodes.length; ++i2) {
                Object argument2 = frame.getArguments()[2 + i2];
                this.parameterTypeNodes[i2].executeAndSet(frame, argument2);
            }
            Object result2 = this.bodyNode.executeGeneric(frame);
            if (this.checkedReturnTypeNode != null) {
                this.checkedReturnTypeNode.execute(frame, result2);
            }
            return result2;
        }
        catch (VmTypeMismatchException e2) {
            CompilerDirectives.transferToInterpreter();
            throw e2.toVmException();
        }
        catch (StackOverflowError e3) {
            CompilerDirectives.transferToInterpreter();
            throw new VmStackOverflowException(e3);
        }
        catch (Exception e4) {
            CompilerDirectives.transferToInterpreter();
            if (e4 instanceof VmException) {
                throw e4;
            }
            throw this.exceptionBuilder().bug(e4.getMessage(), new Object[0]).withCause(e4).build();
        }
    }

    public VmMap getParameterMirrors() {
        VmMap.Builder builder = VmMap.builder();
        for (int i2 = 0; i2 < this.paramCount; ++i2) {
            String parameterName = this.getFrameDescriptor().getSlotName(i2).toString();
            builder.add(parameterName, MirrorFactories.methodParameterFactory.create(Pair.of(parameterName, this.parameterTypeNodes[i2].getMirror())));
        }
        return builder.build();
    }

    public VmTyped getReturnTypeMirror() {
        return TypeNode.getMirror(this.returnTypeNode);
    }

    public PClass.Method export(PClass owner, @Nullable SourceSection docComment, List<VmTyped> annotations2, int modifiers, List<TypeParameter> typeParameters2) {
        LinkedHashMap<String, PType> parameters2 = CollectionUtils.newLinkedHashMap(this.paramCount);
        for (int i2 = 0; i2 < this.paramCount; ++i2) {
            Object slotName = this.getFrameDescriptor().getSlotName(i2);
            Object paramName = slotName == null ? "_#" + i2 : slotName.toString();
            parameters2.put((String)paramName, TypeNode.export(this.parameterTypeNodes[i2]));
        }
        PClass.Method result2 = new PClass.Method(owner, VmUtils.exportDocComment(docComment), new Member.SourceLocation(this.getHeaderSection().getStartLine(), this.getSourceSection().getEndLine()), VmModifier.export(modifiers, false), VmUtils.exportAnnotations(annotations2), this.member.getName().toString(), typeParameters2, parameters2, TypeNode.export(this.returnTypeNode));
        for (TypeParameter parameter : typeParameters2) {
            parameter.initOwner(result2);
        }
        return result2;
    }

    private VmException wrongArgumentCount(int argCount) {
        assert (argCount != this.paramCount);
        return this.exceptionBuilder().evalError("wrongFunctionArgumentCount", this.paramCount, argCount).withSourceSection(this.member.getHeaderSection()).build();
    }
}

