/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.ast.member;

import org.pkl.core.ast.ConstantNode;
import org.pkl.core.ast.MemberNode;
import org.pkl.core.ast.VmModifier;
import org.pkl.core.ast.member.LocalTypedPropertyNode;
import org.pkl.core.ast.member.Member;
import org.pkl.core.runtime.Identifier;
import org.pkl.core.runtime.VmDynamic;
import org.pkl.core.runtime.VmUtils;
import org.pkl.core.util.Nullable;
import org.pkl.thirdparty.truffle.api.CompilerDirectives;
import org.pkl.thirdparty.truffle.api.RootCallTarget;
import org.pkl.thirdparty.truffle.api.source.Source;
import org.pkl.thirdparty.truffle.api.source.SourceSection;

public final class ObjectMember
extends Member {
    @CompilerDirectives.CompilationFinal
    @Nullable
    private Object constantValue;
    @CompilerDirectives.CompilationFinal
    @Nullable
    private MemberNode memberNode;

    public ObjectMember(SourceSection sourceSection, SourceSection headerSection, int modifiers, @Nullable Identifier name, String qualifiedName2) {
        super(sourceSection, headerSection, modifiers, name, qualifiedName2);
    }

    public void initConstantValue(ConstantNode node) {
        this.initConstantValue(node.getValue());
    }

    public void initConstantValue(Object value2) {
        assert (this.constantValue == null);
        assert (this.memberNode == null);
        this.constantValue = value2;
    }

    public void initMemberNode(MemberNode node) {
        assert (this.constantValue == null);
        assert (this.memberNode == null);
        this.memberNode = node;
    }

    public boolean isProp() {
        return this.name != null;
    }

    public boolean isElement() {
        return VmModifier.isElement(this.modifiers);
    }

    public boolean isEntry() {
        return VmModifier.isEntry(this.modifiers);
    }

    @Nullable
    public Object getConstantValue() {
        return this.constantValue;
    }

    @Nullable
    public MemberNode getMemberNode() {
        return this.memberNode;
    }

    public RootCallTarget getCallTarget() {
        assert (this.constantValue == null) : "Must not call getCallTarget() if constantValue is non-null.";
        assert (this.getMemberNode() != null) : "Either constantValue or memberNode must be set, but both are null.";
        RootCallTarget callTarget = this.getMemberNode().getCallTarget();
        assert (callTarget != null);
        return callTarget;
    }

    public boolean isUndefined() {
        return this.getMemberNode() != null && this.getMemberNode().isUndefined();
    }

    @Nullable
    public Object getLocalPropertyDefaultValue() {
        Object object;
        assert (this.isProp() && this.isLocal());
        MemberNode memberNode = this.getMemberNode();
        if (memberNode instanceof LocalTypedPropertyNode) {
            LocalTypedPropertyNode propertyNode = (LocalTypedPropertyNode)memberNode;
            object = propertyNode.getDefaultValue();
        } else {
            object = VmDynamic.empty();
        }
        return object;
    }

    @Override
    @Nullable
    public String getCallSignature() {
        return this.name != null ? this.name.toString() : null;
    }

    public SourceSection getBodySection() {
        if (this.getMemberNode() != null) {
            return this.getMemberNode().getBodySection();
        }
        Source source2 = this.sourceSection.getSource();
        int start2 = this.headerSection.getCharEndIndex();
        int offset = start2 - this.sourceSection.getCharIndex();
        SourceSection candidate = source2.createSection(start2, this.sourceSection.getCharLength() - offset);
        if (candidate.getCharLength() == 0) {
            return VmUtils.unavailableSourceSection();
        }
        int skip = 0;
        CharSequence text = candidate.getCharacters();
        char ch = text.charAt(skip);
        while (ch == '=' || Character.isWhitespace(ch)) {
            ch = text.charAt(++skip);
        }
        return source2.createSection(candidate.getCharIndex() + skip, candidate.getCharLength() - skip);
    }

    public boolean equals(@Nullable Object obj) {
        return this == obj;
    }

    public int hashCode() {
        return System.identityHashCode(this);
    }
}

