/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.ast.member;

import org.pkl.core.ast.ExpressionNode;
import org.pkl.core.ast.member.FunctionNode;
import org.pkl.core.ast.member.ObjectMember;
import org.pkl.core.ast.member.RegularMemberNode;
import org.pkl.core.ast.type.TypeNode;
import org.pkl.core.ast.type.UnresolvedTypeNode;
import org.pkl.core.runtime.VmLanguage;
import org.pkl.core.runtime.VmUtils;
import org.pkl.core.util.LateInit;
import org.pkl.core.util.Nullable;
import org.pkl.thirdparty.truffle.api.CallTarget;
import org.pkl.thirdparty.truffle.api.CompilerDirectives;
import org.pkl.thirdparty.truffle.api.frame.FrameDescriptor;
import org.pkl.thirdparty.truffle.api.frame.VirtualFrame;
import org.pkl.thirdparty.truffle.api.nodes.Node;

public final class ObjectMethodNode
extends RegularMemberNode {
    private final VmLanguage language;
    private final int parameterCount;
    @Node.Children
    @Nullable
    private final UnresolvedTypeNode[] unresolvedParameterTypeNodes;
    @Node.Child
    @Nullable
    private UnresolvedTypeNode unresolvedReturnTypeNode;
    @CompilerDirectives.CompilationFinal
    @LateInit
    private FunctionNode functionNode;

    public ObjectMethodNode(VmLanguage language, FrameDescriptor descriptor2, ObjectMember member, ExpressionNode bodyNode, int parameterCount, @Nullable UnresolvedTypeNode[] unresolvedParameterTypeNodes, @Nullable UnresolvedTypeNode unresolvedReturnTypeNode) {
        super(language, descriptor2, member, bodyNode);
        this.language = language;
        this.parameterCount = parameterCount;
        this.unresolvedParameterTypeNodes = unresolvedParameterTypeNodes;
        this.unresolvedReturnTypeNode = unresolvedReturnTypeNode;
    }

    @Nullable
    public TypeNode getReturnTypeNode() {
        assert (this.functionNode != null);
        return this.functionNode.getReturnTypeNode();
    }

    @Override
    public CallTarget execute(VirtualFrame frame) {
        if (this.functionNode == null) {
            CompilerDirectives.transferToInterpreter();
            TypeNode[] parameterTypeNodes = VmUtils.resolveParameterTypes(frame, this.getFrameDescriptor(), this.unresolvedParameterTypeNodes);
            TypeNode returnTypeNode = this.unresolvedReturnTypeNode != null ? this.unresolvedReturnTypeNode.execute(frame) : null;
            this.functionNode = new FunctionNode(this.language, this.getFrameDescriptor(), this.member, this.parameterCount, parameterTypeNodes, returnTypeNode, true, this.bodyNode);
        }
        return this.functionNode.getCallTarget();
    }
}

