/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.ast.member;

import org.pkl.core.PType;
import org.pkl.core.ast.PklRootNode;
import org.pkl.core.ast.type.TypeNode;
import org.pkl.core.ast.type.VmTypeMismatchException;
import org.pkl.core.runtime.MirrorFactories;
import org.pkl.core.runtime.VmException;
import org.pkl.core.runtime.VmLanguage;
import org.pkl.core.runtime.VmTyped;
import org.pkl.core.util.Nullable;
import org.pkl.thirdparty.truffle.api.CompilerDirectives;
import org.pkl.thirdparty.truffle.api.frame.FrameDescriptor;
import org.pkl.thirdparty.truffle.api.frame.VirtualFrame;
import org.pkl.thirdparty.truffle.api.nodes.Node;
import org.pkl.thirdparty.truffle.api.source.SourceSection;

public final class PropertyTypeNode
extends PklRootNode {
    private final String qualifiedPropertyName;
    @Node.Child
    private TypeNode typeNode;
    @Nullable
    private Object defaultValue;
    private boolean defaultValueInitialized;

    @CompilerDirectives.TruffleBoundary
    public PropertyTypeNode(VmLanguage language, FrameDescriptor descriptor2, String qualifiedPropertyName, TypeNode childNode) {
        super(language, descriptor2);
        this.qualifiedPropertyName = qualifiedPropertyName;
        this.typeNode = childNode;
    }

    public TypeNode getTypeNode() {
        return this.typeNode;
    }

    @Override
    public SourceSection getSourceSection() {
        return this.typeNode.getSourceSection();
    }

    @Override
    public String getName() {
        return this.qualifiedPropertyName;
    }

    @Override
    @Nullable
    public Object execute(VirtualFrame frame) {
        try {
            this.typeNode.execute(frame, frame.getArguments()[2]);
            return null;
        }
        catch (VmTypeMismatchException e2) {
            CompilerDirectives.transferToInterpreter();
            throw e2.toVmException();
        }
        catch (Exception e3) {
            CompilerDirectives.transferToInterpreter();
            if (e3 instanceof VmException) {
                throw e3;
            }
            throw this.exceptionBuilder().bug(e3.getMessage(), new Object[0]).withCause(e3).build();
        }
    }

    @Nullable
    public Object getDefaultValue() {
        if (!this.defaultValueInitialized) {
            this.defaultValue = this.typeNode.createDefaultValue(VmLanguage.get(this), this.getSourceSection(), this.qualifiedPropertyName);
            this.defaultValueInitialized = true;
        }
        return this.defaultValue;
    }

    public boolean isUnknownType() {
        return this.typeNode instanceof TypeNode.UnknownTypeNode;
    }

    public PType export() {
        return TypeNode.export(this.typeNode);
    }

    public VmTyped getMirror() {
        return TypeNode.getMirror(this.typeNode);
    }

    public static PType export(@Nullable PropertyTypeNode node) {
        return node != null ? node.export() : PType.UNKNOWN;
    }

    public static VmTyped getMirror(@Nullable PropertyTypeNode node) {
        return node != null ? node.getMirror() : MirrorFactories.unknownTypeFactory.create(null);
    }
}

