/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.ast.member;

import java.util.List;
import org.pkl.core.ast.ExpressionNode;
import org.pkl.core.ast.VmModifier;
import org.pkl.core.ast.member.ClassProperty;
import org.pkl.core.ast.member.DefaultPropertyBodyNode;
import org.pkl.core.ast.member.ObjectMember;
import org.pkl.core.ast.member.PropertyTypeNode;
import org.pkl.core.ast.member.UnresolvedClassMemberNode;
import org.pkl.core.ast.type.UnresolvedTypeNode;
import org.pkl.core.runtime.Identifier;
import org.pkl.core.runtime.VmClass;
import org.pkl.core.runtime.VmLanguage;
import org.pkl.core.runtime.VmTyped;
import org.pkl.core.runtime.VmUtils;
import org.pkl.core.util.Nullable;
import org.pkl.thirdparty.truffle.api.CompilerDirectives;
import org.pkl.thirdparty.truffle.api.frame.FrameDescriptor;
import org.pkl.thirdparty.truffle.api.frame.VirtualFrame;
import org.pkl.thirdparty.truffle.api.nodes.Node;
import org.pkl.thirdparty.truffle.api.source.SourceSection;

public final class UnresolvedPropertyNode
extends UnresolvedClassMemberNode {
    private final SourceSection propertyNameSection;
    @Node.Child
    @Nullable
    private UnresolvedTypeNode unresolvedTypeNode;
    @Nullable
    private final ExpressionNode bodyNode;

    public UnresolvedPropertyNode(VmLanguage language, SourceSection sourceSection, SourceSection headerSection, SourceSection propertyNameSection, FrameDescriptor descriptor2, @Nullable SourceSection docComment, ExpressionNode[] annotationNodes, int modifiers, Identifier name, String qualifiedName2, @Nullable UnresolvedTypeNode unresolvedTypeNode, @Nullable ExpressionNode bodyNode) {
        super(language, sourceSection, headerSection, descriptor2, docComment, annotationNodes, modifiers, name, qualifiedName2);
        this.propertyNameSection = propertyNameSection;
        this.unresolvedTypeNode = unresolvedTypeNode;
        this.bodyNode = bodyNode;
    }

    public Identifier getName() {
        return this.name;
    }

    public SourceSection getHeaderSection() {
        return this.headerSection;
    }

    public boolean isLocal() {
        return VmModifier.isLocal(this.modifiers);
    }

    public boolean isClass() {
        return VmModifier.isClass(this.modifiers);
    }

    public boolean isTypeAlias() {
        return VmModifier.isTypeAlias(this.modifiers);
    }

    public boolean isImport() {
        return VmModifier.isImport(this.modifiers);
    }

    private void checkOverride(VmClass clazz) {
        VmClass superClass = clazz.getSuperclass();
        if (superClass == null) {
            return;
        }
        ClassProperty superProperty = superClass.getProperty(this.name);
        if (superProperty == null) {
            return;
        }
        boolean isFixed = VmModifier.isFixed(this.modifiers);
        if (superProperty.isFixed() == isFixed) {
            return;
        }
        CompilerDirectives.transferToInterpreter();
        if (superProperty.isFixed()) {
            throw this.exceptionBuilder().withSourceSection(this.headerSection).evalError("missingFixedModifier", this.name, superClass.getQualifiedName(), this.sourceSection.getCharacters()).build();
        }
        String source2 = this.headerSection.getCharacters().toString();
        int fixedModifierIdx = source2.indexOf("fixed");
        throw this.exceptionBuilder().withSourceSection(this.headerSection.getSource().createSection(this.headerSection.getCharIndex() + fixedModifierIdx, 5)).evalError("cannotApplyFixedModifier", this.name, superClass.getQualifiedName()).build();
    }

    private void checkConst(VmClass clazz) {
        VmClass superClass = clazz.getSuperclass();
        if (superClass == null) {
            return;
        }
        ClassProperty superProperty = superClass.getProperty(this.name);
        if (superProperty == null) {
            return;
        }
        boolean isConst = VmModifier.isConst(this.modifiers);
        if (superProperty.isConst() == isConst) {
            return;
        }
        CompilerDirectives.transferToInterpreter();
        if (superProperty.isConst()) {
            throw this.exceptionBuilder().withSourceSection(this.headerSection).evalError("missingConstModifier", this.name, superClass.getQualifiedName(), this.sourceSection.getCharacters()).build();
        }
        String source2 = this.headerSection.getCharacters().toString();
        int constModifierIdx = source2.indexOf("const");
        throw this.exceptionBuilder().withSourceSection(this.headerSection.getSource().createSection(this.headerSection.getCharIndex() + constModifierIdx, 5)).evalError("cannotApplyConstModifier", this.name, superClass.getQualifiedName()).build();
    }

    @Override
    public ClassProperty execute(VirtualFrame frame, VmClass clazz) {
        CompilerDirectives.transferToInterpreter();
        List<VmTyped> annotations2 = VmUtils.evaluateAnnotations(frame, this.annotationNodes);
        PropertyTypeNode typeNode = this.unresolvedTypeNode == null ? null : new PropertyTypeNode(this.language, this.descriptor, this.qualifiedName, this.unresolvedTypeNode.execute(frame));
        this.checkOverride(clazz);
        this.checkConst(clazz);
        ExpressionNode effectiveBodyNode = this.bodyNode != null ? this.bodyNode : new DefaultPropertyBodyNode(this.propertyNameSection, this.name, typeNode);
        ObjectMember initializer = VmUtils.createObjectProperty(this.language, this.sourceSection, this.headerSection, this.name, this.qualifiedName, this.descriptor, this.modifiers, effectiveBodyNode, typeNode);
        return new ClassProperty(this.sourceSection, this.headerSection, this.modifiers, this.name, this.qualifiedName, this.docComment, annotations2, clazz.getPrototype(), typeNode, initializer);
    }
}

