/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.ast.type;

import org.pkl.core.ast.PklRootNode;
import org.pkl.core.ast.type.TypeNode;
import org.pkl.core.ast.type.VmTypeMismatchException;
import org.pkl.core.runtime.VmException;
import org.pkl.core.runtime.VmLanguage;
import org.pkl.core.util.Nullable;
import org.pkl.thirdparty.truffle.api.CompilerDirectives;
import org.pkl.thirdparty.truffle.api.frame.FrameDescriptor;
import org.pkl.thirdparty.truffle.api.frame.VirtualFrame;
import org.pkl.thirdparty.truffle.api.nodes.Node;
import org.pkl.thirdparty.truffle.api.source.SourceSection;

public final class IdentityMixinNode
extends PklRootNode {
    private final SourceSection sourceSection;
    private final String qualifiedName;
    @Node.Child
    @Nullable
    private TypeNode argumentTypeNode;

    public IdentityMixinNode(VmLanguage language, FrameDescriptor descriptor2, SourceSection sourceSection, String qualifiedName2, @Nullable TypeNode argumentTypeNode) {
        super(language, descriptor2);
        this.qualifiedName = qualifiedName2;
        this.sourceSection = sourceSection;
        this.argumentTypeNode = argumentTypeNode;
    }

    @Override
    public SourceSection getSourceSection() {
        return this.sourceSection;
    }

    @Override
    public String getName() {
        return this.qualifiedName;
    }

    @Override
    public Object execute(VirtualFrame frame) {
        Object[] arguments2 = frame.getArguments();
        if (arguments2.length != 3) {
            CompilerDirectives.transferToInterpreter();
            throw this.exceptionBuilder().evalError("wrongFunctionArgumentCount", 1, arguments2.length - 2).withSourceSection(this.sourceSection).build();
        }
        try {
            Object argument2 = arguments2[2];
            if (this.argumentTypeNode != null) {
                this.argumentTypeNode.execute(frame, argument2);
            }
            return argument2;
        }
        catch (VmTypeMismatchException e2) {
            CompilerDirectives.transferToInterpreter();
            throw e2.toVmException();
        }
        catch (Exception e3) {
            CompilerDirectives.transferToInterpreter();
            if (e3 instanceof VmException) {
                throw e3;
            }
            throw this.exceptionBuilder().bug(e3.getMessage(), new Object[0]).withCause(e3).build();
        }
    }
}

