/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.evaluatorSettings;

import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.regex.Pattern;
import org.pkl.core.Duration;
import org.pkl.core.PNull;
import org.pkl.core.PObject;
import org.pkl.core.PklBugException;
import org.pkl.core.PklException;
import org.pkl.core.Value;
import org.pkl.core.util.ErrorMessages;
import org.pkl.core.util.Nullable;

public record PklEvaluatorSettings(@Nullable Map<String, String> externalProperties, @Nullable Map<String, String> env, @Nullable List<Pattern> allowedModules, @Nullable List<Pattern> allowedResources, @Nullable Boolean noCache, @Nullable Path moduleCacheDir, @Nullable List<Path> modulePath, @Nullable Duration timeout, @Nullable Path rootDir, @Nullable Http http) {
    public static PklEvaluatorSettings parse(Value input2, BiFunction<? super String, ? super String, Path> pathNormalizer) {
        if (!(input2 instanceof PObject)) {
            throw PklBugException.unreachableCode();
        }
        PObject pSettings = (PObject)input2;
        String moduleCacheDirStr = (String)pSettings.get("moduleCacheDir");
        Path moduleCacheDir2 = moduleCacheDirStr == null ? null : pathNormalizer.apply(moduleCacheDirStr, "moduleCacheDir");
        List allowedModulesStrs = (List)pSettings.get("allowedModules");
        List<Pattern> allowedModules2 = allowedModulesStrs == null ? null : allowedModulesStrs.stream().map(Pattern::compile).toList();
        List allowedResourcesStrs = (List)pSettings.get("allowedResources");
        List<Pattern> allowedResources2 = allowedResourcesStrs == null ? null : allowedResourcesStrs.stream().map(Pattern::compile).toList();
        List modulePathStrs = (List)pSettings.get("modulePath");
        List<Path> modulePath2 = modulePathStrs == null ? null : modulePathStrs.stream().map(it -> (Path)pathNormalizer.apply((String)it, "modulePath")).toList();
        String rootDirStr = (String)pSettings.get("rootDir");
        Path rootDir2 = rootDirStr == null ? null : pathNormalizer.apply(rootDirStr, "rootDir");
        return new PklEvaluatorSettings((Map)pSettings.get("externalProperties"), (Map)pSettings.get("env"), allowedModules2, allowedResources2, (Boolean)pSettings.get("noCache"), moduleCacheDir2, modulePath2, (Duration)pSettings.get("timeout"), rootDir2, Http.parse((Value)pSettings.get("http")));
    }

    private boolean arePatternsEqual(@Nullable List<Pattern> thesePatterns, @Nullable List<Pattern> thosePatterns) {
        if (thesePatterns == null) {
            return thosePatterns == null;
        }
        if (thosePatterns == null || thesePatterns.size() != thosePatterns.size()) {
            return false;
        }
        for (int i2 = 0; i2 < thesePatterns.size(); ++i2) {
            if (thesePatterns.get(i2).pattern().equals(thosePatterns.get(i2).pattern())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PklEvaluatorSettings)) {
            return false;
        }
        PklEvaluatorSettings that = (PklEvaluatorSettings)obj;
        return Objects.equals(this.externalProperties, that.externalProperties) && Objects.equals(this.env, that.env) && this.arePatternsEqual(this.allowedModules, that.allowedModules) && this.arePatternsEqual(this.allowedResources, that.allowedResources) && Objects.equals(this.noCache, that.noCache) && Objects.equals(this.moduleCacheDir, that.moduleCacheDir) && Objects.equals(this.timeout, that.timeout) && Objects.equals(this.rootDir, that.rootDir) && Objects.equals(this.http, that.http);
    }

    private int hashPatterns(@Nullable List<Pattern> patterns) {
        if (patterns == null) {
            return 0;
        }
        int ret = 1;
        for (Pattern pattern2 : patterns) {
            ret = 31 * ret + pattern2.pattern().hashCode();
        }
        return ret;
    }

    @Override
    public int hashCode() {
        int result2 = Objects.hash(this.externalProperties, this.env, this.noCache, this.moduleCacheDir, this.timeout, this.rootDir, this.http);
        result2 = 31 * result2 + this.hashPatterns(this.allowedModules);
        result2 = 31 * result2 + this.hashPatterns(this.allowedResources);
        return result2;
    }

    public record Http(@Nullable Proxy proxy) {
        public static final Http DEFAULT = new Http(null);

        @Nullable
        public static Http parse(@Nullable Value input2) {
            if (input2 == null || input2 instanceof PNull) {
                return null;
            }
            if (input2 instanceof PObject) {
                PObject http = (PObject)input2;
                Proxy proxy = Proxy.parse((Value)http.getProperty("proxy"));
                return proxy == null ? DEFAULT : new Http(proxy);
            }
            throw PklBugException.unreachableCode();
        }
    }

    public record Proxy(@Nullable URI address, @Nullable List<String> noProxy) {
        public static Proxy create(@Nullable String address2, @Nullable List<String> noProxy2) {
            URI addressUri;
            try {
                addressUri = address2 == null ? null : new URI(address2);
            }
            catch (URISyntaxException e2) {
                throw new PklException(ErrorMessages.create("invalidUri", address2));
            }
            return new Proxy(addressUri, noProxy2);
        }

        @Nullable
        public static Proxy parse(Value input2) {
            if (input2 instanceof PNull) {
                return null;
            }
            if (input2 instanceof PObject) {
                PObject proxy = (PObject)input2;
                String address2 = (String)proxy.get("address");
                List noProxy2 = (List)proxy.get("noProxy");
                return Proxy.create(address2, noProxy2);
            }
            throw PklBugException.unreachableCode();
        }
    }
}

