/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.http;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.SocketAddress;
import java.net.URI;
import java.util.List;
import org.pkl.core.http.NoProxyRule;
import org.pkl.core.util.ErrorMessages;
import org.pkl.core.util.Nullable;
import org.pkl.thirdparty.truffle.api.nodes.ExplodeLoop;

final class ProxySelector
extends java.net.ProxySelector {
    public static final List<Proxy> NO_PROXY = List.of(Proxy.NO_PROXY);
    @Nullable
    private final List<Proxy> myProxy;
    private final List<NoProxyRule> noProxyRules;
    @Nullable
    private final java.net.ProxySelector delegate;

    ProxySelector(@Nullable URI proxyAddress2, List<String> noProxyRules) {
        this.noProxyRules = noProxyRules.stream().map(NoProxyRule::new).toList();
        if (proxyAddress2 == null) {
            this.delegate = java.net.ProxySelector.getDefault();
            this.myProxy = null;
        } else {
            if (!proxyAddress2.getScheme().equalsIgnoreCase("http") || proxyAddress2.getHost() == null || !proxyAddress2.getPath().isEmpty() || proxyAddress2.getUserInfo() != null) {
                throw new IllegalArgumentException(ErrorMessages.create("malformedProxyAddress", proxyAddress2));
            }
            this.delegate = null;
            int port = proxyAddress2.getPort();
            if (port == -1) {
                port = 80;
            }
            this.myProxy = List.of(new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyAddress2.getHost(), port)));
        }
    }

    @Override
    @ExplodeLoop
    public List<Proxy> select(URI uri) {
        for (NoProxyRule proxyRule : this.noProxyRules) {
            if (!proxyRule.matches(uri)) continue;
            return NO_PROXY;
        }
        if (this.delegate != null) {
            return this.delegate.select(uri);
        }
        assert (this.myProxy != null);
        return this.myProxy;
    }

    @Override
    public void connectFailed(URI uri, SocketAddress sa, IOException ioe) {
    }
}

