/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.module;

import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.AccessDeniedException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.pkl.core.module.ModuleKey;
import org.pkl.core.module.ResolvedModuleKey;
import org.pkl.core.util.IoUtils;

public final class ResolvedModuleKeys {
    private ResolvedModuleKeys() {
    }

    public static ResolvedModuleKey file(ModuleKey original, URI uri, Path path2) {
        return new File(original, uri, path2);
    }

    public static ResolvedModuleKey url(ModuleKey original, URI uri, URL url2) {
        return new Url(original, uri, url2);
    }

    public static ResolvedModuleKey virtual(ModuleKey original, URI uri, String sourceText, boolean cached) {
        return new Virtual(original, uri, sourceText, cached);
    }

    public static ResolvedModuleKey delegated(ResolvedModuleKey delegate2, ModuleKey original) {
        return new Delegated(delegate2, original);
    }

    private static class File
    implements ResolvedModuleKey {
        final ModuleKey original;
        final URI uri;
        final Path path;

        File(ModuleKey original, URI uri, Path path2) {
            this.original = original;
            this.uri = uri;
            this.path = path2;
        }

        @Override
        public ModuleKey getOriginal() {
            return this.original;
        }

        @Override
        public URI getUri() {
            return this.uri;
        }

        @Override
        public String loadSource() throws IOException {
            try {
                return Files.readString(this.path, StandardCharsets.UTF_8);
            }
            catch (AccessDeniedException e2) {
                if (Files.isDirectory(this.path, new LinkOption[0])) {
                    throw new IOException("Is a directory");
                }
                throw e2;
            }
        }
    }

    private static class Url
    implements ResolvedModuleKey {
        final ModuleKey original;
        final URI uri;
        final URL url;

        Url(ModuleKey original, URI uri, URL url2) {
            this.original = original;
            this.uri = uri;
            this.url = url2;
        }

        @Override
        public ModuleKey getOriginal() {
            return this.original;
        }

        @Override
        public URI getUri() {
            return this.uri;
        }

        @Override
        public String loadSource() throws IOException {
            return IoUtils.readString(this.url);
        }
    }

    private static class Virtual
    implements ResolvedModuleKey {
        final ModuleKey original;
        final URI uri;
        final String sourceText;
        final boolean cached;

        Virtual(ModuleKey original, URI uri, String sourceText, boolean cached) {
            this.original = original;
            this.uri = uri;
            this.sourceText = sourceText;
            this.cached = cached;
        }

        @Override
        public ModuleKey getOriginal() {
            return this.original;
        }

        @Override
        public URI getUri() {
            return this.uri;
        }

        @Override
        public String loadSource() {
            return this.sourceText;
        }
    }

    private static class Delegated
    implements ResolvedModuleKey {
        private final ResolvedModuleKey delegate;
        private final ModuleKey original;

        Delegated(ResolvedModuleKey delegate2, ModuleKey original) {
            this.delegate = delegate2;
            this.original = original;
        }

        @Override
        public ModuleKey getOriginal() {
            return this.original;
        }

        @Override
        public URI getUri() {
            return this.delegate.getUri();
        }

        @Override
        public String loadSource() throws IOException {
            return this.delegate.loadSource();
        }
    }
}

