/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.project;

import java.net.URI;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import org.pkl.core.Version;
import org.pkl.core.packages.PackageUri;
import org.pkl.core.util.Nullable;

public final class Package {
    private final String name;
    private final PackageUri uri;
    private final Version version;
    private final URI packageZipUrl;
    @Nullable
    private final String description;
    private final List<String> authors;
    @Nullable
    private final URI website;
    @Nullable
    private final URI documentation;
    @Nullable
    private final URI sourceCode;
    @Nullable
    private final String sourceCodeUrlScheme;
    @Nullable
    private final String license;
    @Nullable
    private final String licenseText;
    @Nullable
    private final URI issueTracker;
    private final List<Path> apiTests;
    private final List<String> exclude;

    public Package(String name, PackageUri uri, Version version, URI packageZipUrl, @Nullable String description2, List<String> authors, @Nullable URI website, @Nullable URI documentation, @Nullable URI sourceCode, @Nullable String sourceCodeUrlScheme, @Nullable String license, @Nullable String licenseText, @Nullable URI issueTracker, List<Path> apiTests, List<String> exclude) {
        this.name = name;
        this.uri = uri;
        this.version = version;
        this.packageZipUrl = packageZipUrl;
        this.description = description2;
        this.authors = authors;
        this.website = website;
        this.documentation = documentation;
        this.sourceCode = sourceCode;
        this.sourceCodeUrlScheme = sourceCodeUrlScheme;
        this.license = license;
        this.licenseText = licenseText;
        this.issueTracker = issueTracker;
        this.apiTests = apiTests;
        this.exclude = exclude;
    }

    public String getName() {
        return this.name;
    }

    public PackageUri getUri() {
        return this.uri;
    }

    public Version getVersion() {
        return this.version;
    }

    public URI getPackageZipUrl() {
        return this.packageZipUrl;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    public List<String> getAuthors() {
        return this.authors;
    }

    @Nullable
    public URI getWebsite() {
        return this.website;
    }

    @Nullable
    public URI getDocumentation() {
        return this.documentation;
    }

    @Nullable
    public URI getSourceCode() {
        return this.sourceCode;
    }

    @Nullable
    public String getSourceCodeUrlScheme() {
        return this.sourceCodeUrlScheme;
    }

    @Nullable
    public String getLicenseText() {
        return this.licenseText;
    }

    @Nullable
    public String getLicense() {
        return this.license;
    }

    @Nullable
    public URI getIssueTracker() {
        return this.issueTracker;
    }

    public List<Path> getApiTests() {
        return this.apiTests;
    }

    public List<String> getExclude() {
        return this.exclude;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Package aPackage = (Package)o;
        return this.name.equals(aPackage.name) && this.uri.equals(aPackage.uri) && this.version.equals(aPackage.version) && Objects.equals(this.description, aPackage.description) && this.authors.equals(aPackage.authors) && Objects.equals(this.website, aPackage.website) && Objects.equals(this.documentation, aPackage.documentation) && Objects.equals(this.sourceCode, aPackage.sourceCode) && Objects.equals(this.sourceCodeUrlScheme, aPackage.sourceCodeUrlScheme) && Objects.equals(this.license, aPackage.license) && Objects.equals(this.licenseText, aPackage.licenseText) && Objects.equals(this.issueTracker, aPackage.issueTracker) && Objects.equals(this.apiTests, aPackage.apiTests) && this.exclude.equals(aPackage.exclude);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.uri, this.version, this.description, this.authors, this.website, this.documentation, this.sourceCode, this.sourceCodeUrlScheme, this.license, this.licenseText, this.issueTracker, this.apiTests, this.exclude);
    }

    public String toString() {
        return "Package{name=" + this.name + ", uri=" + this.uri + ", version='" + this.version + "', description='" + this.description + "', authors=" + this.authors + ", website='" + this.website + ", documentation='" + this.documentation + "', sourceCode='" + this.sourceCode + "', sourceCodeUrlScheme='" + this.sourceCodeUrlScheme + "', license='" + this.license + "', licenseText='" + this.licenseText + "', issueTracker='" + this.issueTracker + "', apiTests='" + this.apiTests + "', exclude='" + this.exclude + "'}";
    }
}

