/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.project;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.time.LocalDateTime;
import java.time.Month;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.pkl.core.PklBugException;
import org.pkl.core.PklException;
import org.pkl.core.SecurityManager;
import org.pkl.core.SecurityManagerException;
import org.pkl.core.StackFrameTransformer;
import org.pkl.core.ast.builder.ImportsAndReadsParser;
import org.pkl.core.http.HttpClient;
import org.pkl.core.module.ModuleKey;
import org.pkl.core.module.ModuleKeyFactories;
import org.pkl.core.module.ModuleKeys;
import org.pkl.core.module.ProjectDependenciesManager;
import org.pkl.core.module.ResolvedModuleKey;
import org.pkl.core.module.ResolvedModuleKeys;
import org.pkl.core.packages.Checksums;
import org.pkl.core.packages.Dependency;
import org.pkl.core.packages.DependencyMetadata;
import org.pkl.core.packages.PackageLoadError;
import org.pkl.core.packages.PackageResolver;
import org.pkl.core.packages.PackageUri;
import org.pkl.core.project.Package;
import org.pkl.core.project.Project;
import org.pkl.core.runtime.ModuleResolver;
import org.pkl.core.runtime.VmExceptionBuilder;
import org.pkl.core.util.ByteArrayUtils;
import org.pkl.core.util.ErrorMessages;
import org.pkl.core.util.GlobResolver;
import org.pkl.core.util.IoUtils;
import org.pkl.core.util.Nullable;
import org.pkl.core.util.Pair;
import org.pkl.thirdparty.graalvm.collections.EconomicMap;
import org.pkl.thirdparty.truffle.api.source.SourceSection;

public final class ProjectPackager {
    private static final LocalDateTime ZIP_ENTRY_MTIME = LocalDateTime.of(1980, Month.FEBRUARY, 1, 0, 0);
    private final EconomicMap<PackageUri, PackageResult> packageResults = EconomicMap.create();
    private final List<Project> projects;
    private final Path workingDir;
    private final String outputPathPattern;
    private final StackFrameTransformer stackFrameTransformer;
    private final SecurityManager securityManager;
    private final PackageResolver packageResolver;
    private final boolean skipPublishCheck;
    private final Writer outputWriter;

    public ProjectPackager(List<Project> projects, Path workingDir, String outputPathPattern, StackFrameTransformer stackFrameTransformer2, SecurityManager securityManager2, HttpClient httpClient2, boolean skipPublishCheck, Writer outputWriter) {
        this.projects = projects;
        this.workingDir = workingDir;
        this.outputPathPattern = outputPathPattern;
        this.stackFrameTransformer = stackFrameTransformer2;
        this.securityManager = securityManager2;
        this.packageResolver = PackageResolver.getInstance(securityManager2, httpClient2, null);
        this.skipPublishCheck = skipPublishCheck;
        this.outputWriter = outputWriter;
    }

    private void writeLine(String line) throws IOException {
        this.outputWriter.write(line);
        this.outputWriter.write(IoUtils.getLineSeparator());
    }

    public void createPackages() throws IOException {
        for (Project project2 : this.projects) {
            PackageResult packageResult = this.doPackage(project2);
            this.writeLine(IoUtils.relativize(packageResult.getMetadataFile(), this.workingDir).toString());
            this.writeLine(IoUtils.relativize(packageResult.getMetadataChecksumFile(), this.workingDir).toString());
            this.writeLine(IoUtils.relativize(packageResult.getZipFile(), this.workingDir).toString());
            this.writeLine(IoUtils.relativize(packageResult.getZipChecksumFile(), this.workingDir).toString());
            this.outputWriter.flush();
        }
    }

    private Path resolveOutputDirectory(Package pkg) {
        String substituted = this.outputPathPattern.replace("%{name}", pkg.getName()).replace("%{version}", pkg.getVersion().toString());
        return this.workingDir.resolve(substituted);
    }

    public PackageResult doPackage(Project project2) throws IOException {
        Package pkg = project2.getPackage();
        if (pkg == null) {
            throw new PklException(ErrorMessages.create("noPackageDefinedByProject", project2.getProjectFileUri()));
        }
        if (this.packageResults.containsKey(pkg.getUri())) {
            return (PackageResult)this.packageResults.get(pkg.getUri());
        }
        List<Path> files = this.collectPackageElements(project2, pkg);
        this.validatePklImportsAndReads(project2, files);
        Path outputDir = this.resolveOutputDirectory(pkg);
        String metadataFileName = IoUtils.takeLastSegment(pkg.getUri().getUri().getPath(), '/');
        Path metadataFile = outputDir.resolve(metadataFileName);
        Path metadataChecksumFile = outputDir.resolve(metadataFileName + ".sha256");
        Path zipFile = outputDir.resolve(metadataFileName + ".zip");
        Path zipChecksumFile = outputDir.resolve(metadataFileName + ".zip.sha256");
        String zipFileChecksum = this.createPackageZipAndComputeChecksum(project2, files, zipFile);
        String metadataFileChecksum = this.createDependencyMetadataAndComputeChecksum(project2, pkg, metadataFile, zipFileChecksum);
        Files.writeString(zipChecksumFile, (CharSequence)zipFileChecksum, new OpenOption[0]);
        Files.writeString(metadataChecksumFile, (CharSequence)metadataFileChecksum, new OpenOption[0]);
        if (!this.skipPublishCheck) {
            this.checkAlreadyPublishedPackage(pkg, metadataFileChecksum);
        }
        PackageResult result2 = new PackageResult(metadataFile, metadataChecksumFile, zipFile, zipChecksumFile, metadataFileChecksum);
        this.packageResults.put(pkg.getUri(), result2);
        return result2;
    }

    private void checkAlreadyPublishedPackage(Package pkg, String computedChecksum) throws IOException {
        try {
            Pair<DependencyMetadata, Checksums> metadataAndChecksum = this.packageResolver.getDependencyMetadataAndComputeChecksum(pkg.getUri());
            String receivedChecksum = ((Checksums)metadataAndChecksum.second).getSha256();
            if (!receivedChecksum.equals(computedChecksum)) {
                throw new PklException(ErrorMessages.create("packageAlreadyPublishedWithDifferentContents", pkg.getUri(), computedChecksum, receivedChecksum));
            }
        }
        catch (PackageLoadError e2) {
            if (e2.getMessageName().equals("badHttpStatusCode")) {
                if ((Integer)e2.getArguments()[0] == 404) {
                    return;
                }
                throw new PklException(ErrorMessages.create("unableToAccessPublishedPackage", pkg.getName(), pkg.getPackageZipUrl(), e2.getArguments()[0]));
            }
            throw e2;
        }
        catch (SecurityManagerException e3) {
            throw new PklException(e3.getMessage());
        }
    }

    private String createDependencyMetadataAndComputeChecksum(Project project2, Package pkg, Path metadataFile, String zipFileChecksum) throws IOException {
        DependencyMetadata dependencyMetadata = this.createDependencyMetadata(project2, pkg, zipFileChecksum);
        try (DigestOutputStream fos = this.newDigestOutputStream(Files.newOutputStream(metadataFile, new OpenOption[0]));){
            dependencyMetadata.writeTo(fos);
            String string = ByteArrayUtils.toHex(fos.getMessageDigest().digest());
            return string;
        }
    }

    private Map<String, Dependency.RemoteDependency> buildDependencies(Project project2) throws IOException {
        try {
            HashMap<String, Dependency.RemoteDependency> ret = new HashMap<String, Dependency.RemoteDependency>(project2.getDependencies().getLocalDependencies().size() + project2.getDependencies().getRemoteDependencies().size());
            ModuleResolver moduleResolver = new ModuleResolver(List.of(ModuleKeyFactories.file));
            ProjectDependenciesManager projectDependenciesManager = new ProjectDependenciesManager(project2.getDependencies(), moduleResolver, this.securityManager);
            for (Map.Entry<String, Dependency.RemoteDependency> entry : project2.getDependencies().getRemoteDependencies().entrySet()) {
                Dependency.RemoteDependency resolved = (Dependency.RemoteDependency)projectDependenciesManager.getResolvedDependency(entry.getValue().getPackageUri());
                ret.put(entry.getKey(), new Dependency.RemoteDependency(resolved.getPackageUri().toExternalPackageUri(), resolved.getChecksums()));
            }
            for (Map.Entry<String, Object> entry : project2.getLocalProjectDependencies().entrySet()) {
                Project localProject = (Project)entry.getValue();
                assert (localProject.getPackage() != null);
                PackageUri packageUri = localProject.getPackage().getUri();
                Dependency resolved = projectDependenciesManager.getResolvedDependency(packageUri);
                if (resolved instanceof Dependency.LocalDependency) {
                    PackageResult packageResult = this.doPackage(localProject);
                    ret.put(entry.getKey(), new Dependency.RemoteDependency(packageUri.toExternalPackageUri(), new Checksums(packageResult.getMetadataChecksum())));
                    continue;
                }
                Dependency.RemoteDependency remoteDep = (Dependency.RemoteDependency)resolved;
                ret.put(entry.getKey(), new Dependency.RemoteDependency(remoteDep.getPackageUri().toExternalPackageUri(), remoteDep.getChecksums()));
            }
            return ret;
        }
        catch (PackageLoadError e2) {
            throw new PklException(ErrorMessages.create("unexpectedPackageLoadError", project2.getProjectFileUri(), e2.getMessage()), e2);
        }
    }

    private DependencyMetadata createDependencyMetadata(Project project2, Package pkg, String packageZipChecksum) throws IOException {
        return new DependencyMetadata(pkg.getName(), pkg.getUri(), pkg.getVersion(), pkg.getPackageZipUrl(), new Checksums(packageZipChecksum), this.buildDependencies(project2), pkg.getSourceCodeUrlScheme(), pkg.getSourceCode(), pkg.getDocumentation(), pkg.getLicense(), pkg.getLicenseText(), pkg.getAuthors(), pkg.getIssueTracker(), pkg.getDescription());
    }

    private DigestOutputStream newDigestOutputStream(OutputStream outputStream2) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            return new DigestOutputStream(outputStream2, md);
        }
        catch (NoSuchAlgorithmException e2) {
            throw PklBugException.unreachableCode();
        }
    }

    private String createPackageZipAndComputeChecksum(Project project2, List<Path> files, Path outputZipFile) {
        DigestOutputStream digestOutputStream;
        try {
            Files.createDirectories(outputZipFile.getParent(), new FileAttribute[0]);
            digestOutputStream = this.newDigestOutputStream(Files.newOutputStream(outputZipFile, new OpenOption[0]));
        }
        catch (IOException e2) {
            throw new UncheckedIOException(e2);
        }
        try (ZipOutputStream zos = new ZipOutputStream(digestOutputStream);){
            for (Path file2 : files) {
                Path relativePath = IoUtils.relativize(file2, project2.getProjectDir());
                ZipEntry zipEntry = new ZipEntry(IoUtils.toNormalizedPathString(relativePath));
                zipEntry.setTimeLocal(ZIP_ENTRY_MTIME);
                zos.putNextEntry(zipEntry);
                Files.copy(file2, zos);
                zos.closeEntry();
            }
        }
        catch (IOException e3) {
            throw new UncheckedIOException(e3);
        }
        return ByteArrayUtils.toHex(digestOutputStream.getMessageDigest().digest());
    }

    private void validatePklImportsAndReads(Project project2, List<Path> files) {
        for (Path file2 : files) {
            if (!file2.toString().endsWith(".pkl")) continue;
            this.validateImportsAndReads(project2, file2);
        }
    }

    private List<Pattern> getExcludePatterns(Package pkg) {
        ArrayList<Pattern> excludePatterns = new ArrayList<Pattern>();
        for (String s2 : pkg.getExclude()) {
            try {
                excludePatterns.add(GlobResolver.toRegexPattern(s2));
            }
            catch (GlobResolver.InvalidGlobPatternException e2) {
                throw new PklException(e2.getMessage(), e2);
            }
        }
        return excludePatterns;
    }

    private List<Path> collectPackageElements(Project project2, Package pkg) {
        List<Path> list;
        block8: {
            List<Pattern> excludePatterns = this.getExcludePatterns(pkg);
            Stream<Path> stream = Files.walk(project2.getProjectDir(), new FileVisitOption[0]);
            try {
                list = stream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(it -> {
                    Path relativePath = IoUtils.relativize(it, project2.getProjectDir());
                    String fileNameRelativeToProjectRoot = IoUtils.toNormalizedPathString(relativePath);
                    for (Pattern pattern2 : excludePatterns) {
                        if (pattern2.matcher(it.getFileName().toString()).matches()) {
                            return false;
                        }
                        if (!pattern2.matcher(fileNameRelativeToProjectRoot).matches()) continue;
                        return false;
                    }
                    return true;
                }).sorted().collect(Collectors.toList());
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e2) {
                    throw new UncheckedIOException(e2);
                }
            }
            stream.close();
        }
        return list;
    }

    private boolean isAbsoluteImport(String importStr) {
        return importStr.matches("\\w+:.*") || importStr.startsWith("@");
    }

    public void validateImportsAndReads(Project project2, Path pklModulePath) {
        List<Pair<String, SourceSection>> imports = this.getImportsAndReads(pklModulePath);
        if (imports == null) {
            return;
        }
        for (Pair<String, SourceSection> importContext : imports) {
            URI importUri;
            String importStr = (String)importContext.first;
            SourceSection sourceSection = (SourceSection)importContext.second;
            if (this.isAbsoluteImport(importStr)) continue;
            try {
                importUri = IoUtils.toUri(importStr);
            }
            catch (URISyntaxException e2) {
                throw new VmExceptionBuilder().evalError("invalidModuleUri", importStr).withSourceSection(sourceSection).build().toPklException(this.stackFrameTransformer);
            }
            if (importStr.startsWith("/") && !project2.getProjectDir().toString().equals("/")) {
                throw new VmExceptionBuilder().evalError("invalidRelativeProjectImport", importStr).withSourceSection(sourceSection).build().toPklException(this.stackFrameTransformer);
            }
            Path currentPath = pklModulePath.getParent();
            Path importPath = Path.of(importUri.getPath(), new String[0]);
            for (int i2 = 0; i2 < importPath.getNameCount(); ++i2) {
                Path segment = importPath.getName(i2);
                Path normalized = (currentPath = currentPath.resolve(segment)).normalize();
                if (normalized.startsWith(project2.getProjectDir())) continue;
                throw new VmExceptionBuilder().evalError("invalidRelativeProjectImport", importStr).withSourceSection(sourceSection).build().toPklException(this.stackFrameTransformer);
            }
        }
    }

    @Nullable
    private List<Pair<String, SourceSection>> getImportsAndReads(Path pklModulePath) {
        try {
            ModuleKey moduleKey = ModuleKeys.file(pklModulePath.toUri());
            ResolvedModuleKey resolvedModuleKey = ResolvedModuleKeys.file(moduleKey, moduleKey.getUri(), pklModulePath);
            return ImportsAndReadsParser.parse(moduleKey, resolvedModuleKey);
        }
        catch (IOException e2) {
            throw new UncheckedIOException(e2);
        }
    }

    public static class PackageResult {
        private final Path zipFile;
        private final Path zipChecksumFile;
        private final Path metadataFile;
        private final Path metadataChecksumFile;
        private final String metadataChecksum;

        public PackageResult(Path zipFile, Path zipChecksumFile, Path metadataFile, Path metadataChecksumFile, String metadataChecksum) {
            this.zipFile = zipFile;
            this.zipChecksumFile = zipChecksumFile;
            this.metadataFile = metadataFile;
            this.metadataChecksumFile = metadataChecksumFile;
            this.metadataChecksum = metadataChecksum;
        }

        public Path getZipFile() {
            return this.zipFile;
        }

        public Path getZipChecksumFile() {
            return this.zipChecksumFile;
        }

        public Path getMetadataFile() {
            return this.metadataFile;
        }

        public Path getMetadataChecksumFile() {
            return this.metadataChecksumFile;
        }

        public String getMetadataChecksum() {
            return this.metadataChecksum;
        }
    }
}

