/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.repl;

import java.net.URI;

public abstract class ReplRequest {
    public final String id;

    private ReplRequest(String id2) {
        if (id2.isEmpty()) {
            throw new IllegalArgumentException("Request ID must be empty.");
        }
        this.id = id2;
    }

    public static final class Reset
    extends ReplRequest {
        public Reset(String id2) {
            super(id2);
        }

        public String toString() {
            return String.format("%s()", this.getClass().getSimpleName());
        }
    }

    public static final class Completion
    extends ReplRequest {
        public final String text;

        public Completion(String id2, String text) {
            super(id2);
            this.text = text;
        }

        public String toString() {
            return String.format("%s(text=%s)", this.getClass().getSimpleName(), this.text);
        }
    }

    public static final class Load
    extends ReplRequest {
        public final URI uri;

        public Load(String id2, URI uri) {
            super(id2);
            this.uri = uri;
        }

        public String toString() {
            return String.format("%s(url=%s)", this.getClass().getSimpleName(), this.uri);
        }
    }

    public static final class Eval
    extends ReplRequest {
        public final String text;
        public final boolean evalDefinitions;
        public final boolean forceResults;

        public Eval(String id2, String text, boolean evalDefinitions, boolean forceResults) {
            super(id2);
            this.text = text;
            this.evalDefinitions = evalDefinitions;
            this.forceResults = forceResults;
        }

        public String toString() {
            return String.format("%s(text=%s,evalDefinitions=%s,forceResults=%s)", this.getClass().getSimpleName(), this.text, this.evalDefinitions, this.forceResults);
        }
    }
}

