/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.repl;

import java.io.IOException;
import java.net.URI;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.pkl.core.Logger;
import org.pkl.core.PClassInfo;
import org.pkl.core.SecurityManager;
import org.pkl.core.SecurityManagerException;
import org.pkl.core.StackFrameTransformer;
import org.pkl.core.ast.ExpressionNode;
import org.pkl.core.ast.SimpleRootNode;
import org.pkl.core.ast.builder.AstBuilder;
import org.pkl.core.ast.member.ClassMethod;
import org.pkl.core.ast.member.ClassProperty;
import org.pkl.core.ast.member.ObjectMember;
import org.pkl.core.ast.member.UnresolvedMethodNode;
import org.pkl.core.ast.member.UnresolvedPropertyNode;
import org.pkl.core.ast.repl.ResolveClassMemberNode;
import org.pkl.core.ast.type.TypeNode;
import org.pkl.core.http.HttpClient;
import org.pkl.core.module.ModuleKey;
import org.pkl.core.module.ModuleKeyFactory;
import org.pkl.core.module.ModuleKeys;
import org.pkl.core.module.ProjectDependenciesManager;
import org.pkl.core.module.ResolvedModuleKey;
import org.pkl.core.packages.PackageResolver;
import org.pkl.core.parser.LexParseException;
import org.pkl.core.parser.Parser;
import org.pkl.core.parser.antlr.PklParser;
import org.pkl.core.project.DeclaredDependencies;
import org.pkl.core.repl.ReplRequest;
import org.pkl.core.repl.ReplResponse;
import org.pkl.core.resource.ResourceReader;
import org.pkl.core.runtime.BaseModule;
import org.pkl.core.runtime.Identifier;
import org.pkl.core.runtime.ModuleInfo;
import org.pkl.core.runtime.ModuleResolver;
import org.pkl.core.runtime.ResourceManager;
import org.pkl.core.runtime.StackTraceRenderer;
import org.pkl.core.runtime.VmClass;
import org.pkl.core.runtime.VmContext;
import org.pkl.core.runtime.VmException;
import org.pkl.core.runtime.VmExceptionBuilder;
import org.pkl.core.runtime.VmExceptionRenderer;
import org.pkl.core.runtime.VmLanguage;
import org.pkl.core.runtime.VmObjectLike;
import org.pkl.core.runtime.VmTyped;
import org.pkl.core.runtime.VmUtils;
import org.pkl.core.runtime.VmValue;
import org.pkl.core.runtime.VmValueRenderer;
import org.pkl.core.util.EconomicMaps;
import org.pkl.core.util.IoUtils;
import org.pkl.core.util.MutableReference;
import org.pkl.core.util.Nullable;
import org.pkl.thirdparty.antlr.v4.runtime.tree.ParseTree;
import org.pkl.thirdparty.antlr.v4.runtime.tree.TerminalNode;
import org.pkl.thirdparty.graalvm.collections.UnmodifiableEconomicMap;
import org.pkl.thirdparty.graalvm.polyglot.Context;
import org.pkl.thirdparty.truffle.api.Truffle;
import org.pkl.thirdparty.truffle.api.frame.FrameDescriptor;
import org.pkl.thirdparty.truffle.api.nodes.IndirectCallNode;

public class ReplServer
implements AutoCloseable {
    private final IndirectCallNode callNode = Truffle.getRuntime().createIndirectCallNode();
    private final Context polyglotContext;
    private final VmLanguage language;
    private final ReplState replState;
    private final Path workingDir;
    private final SecurityManager securityManager;
    private final ModuleResolver moduleResolver;
    private final VmExceptionRenderer errorRenderer;
    private final PackageResolver packageResolver;
    @Nullable
    private final ProjectDependenciesManager projectDependenciesManager;

    public ReplServer(SecurityManager securityManager2, HttpClient httpClient2, Logger logger, Collection<ModuleKeyFactory> moduleKeyFactories, Collection<ResourceReader> resourceReaders, Map<String, String> environmentVariables2, Map<String, String> externalProperties2, @Nullable Path moduleCacheDir2, @Nullable DeclaredDependencies projectDependencies, @Nullable String outputFormat, Path workingDir, StackFrameTransformer frameTransformer) {
        this.workingDir = workingDir;
        this.securityManager = securityManager2;
        this.moduleResolver = new ModuleResolver(moduleKeyFactories);
        this.errorRenderer = new VmExceptionRenderer(new StackTraceRenderer(frameTransformer));
        this.replState = new ReplState(this.createEmptyReplModule(BaseModule.getModuleClass().getPrototype()));
        MutableReference<Object> languageRef = new MutableReference<Object>(null);
        this.packageResolver = PackageResolver.getInstance(securityManager2, httpClient2, moduleCacheDir2);
        this.projectDependenciesManager = projectDependencies == null ? null : new ProjectDependenciesManager(projectDependencies, this.moduleResolver, securityManager2);
        this.polyglotContext = VmUtils.createContext(() -> {
            languageRef.set(VmLanguage.get(null));
            VmContext vmContext = VmContext.get(null);
            vmContext.initialize(new VmContext.Holder(frameTransformer, securityManager2, httpClient2, this.moduleResolver, new ResourceManager(securityManager2, resourceReaders), logger, environmentVariables2, externalProperties2, moduleCacheDir2, outputFormat, this.packageResolver, this.projectDependenciesManager));
        });
        this.language = languageRef.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ReplResponse> handleRequest(ReplRequest request) {
        this.polyglotContext.enter();
        try {
            if (request instanceof ReplRequest.Eval) {
                ReplRequest.Eval eval = (ReplRequest.Eval)request;
                List<ReplResponse> list = this.handleEval(eval);
                return list;
            }
            if (request instanceof ReplRequest.Load) {
                ReplRequest.Load load = (ReplRequest.Load)request;
                List<ReplResponse> list = this.handleLoad(load);
                return list;
            }
            if (request instanceof ReplRequest.Completion) {
                ReplRequest.Completion completion = (ReplRequest.Completion)request;
                List<ReplResponse> list = this.handleCompletion(completion);
                return list;
            }
            if (request instanceof ReplRequest.Reset) {
                List<ReplResponse> completion = this.handleReset();
                return completion;
            }
            List<ReplResponse> completion = List.of(new ReplResponse.InvalidRequest("Unsupported request type: " + request.getClass().getSimpleName()));
            return completion;
        }
        catch (Exception e2) {
            List<ReplResponse> list = List.of(new ReplResponse.InternalError(e2));
            return list;
        }
        finally {
            this.polyglotContext.leave();
        }
    }

    @Override
    public void close() {
        this.polyglotContext.close(true);
        try {
            this.packageResolver.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private List<ReplResponse> handleEval(ReplRequest.Eval request) {
        List<Object> results = this.evaluate(this.replState, request.id, request.text, request.evalDefinitions, request.forceResults);
        return results.stream().map(result2 -> {
            ReplResponse replResponse;
            if (result2 instanceof ReplResponse) {
                ReplResponse response = (ReplResponse)result2;
                replResponse = response;
            } else {
                replResponse = new ReplResponse.EvalSuccess(this.render(result2));
            }
            return replResponse;
        }).collect(Collectors.toList());
    }

    private List<Object> evaluate(ReplState replState, String requestId, String text, boolean evalDefinitions, boolean forceResults) {
        ResolvedModuleKey resolved;
        PklParser.ReplInputContext replInputContext;
        Parser parser = new Parser();
        URI uri = URI.create("repl:" + requestId);
        try {
            replInputContext = parser.parseReplInput(text);
        }
        catch (LexParseException.IncompleteInput e2) {
            return List.of(new ReplResponse.IncompleteInput(e2.getMessage()));
        }
        catch (LexParseException e3) {
            VmException exception = VmUtils.toVmException(e3, text, uri, uri.toString());
            String errorMessage2 = this.errorRenderer.render(exception);
            return List.of(new ReplResponse.EvalError(errorMessage2));
        }
        ArrayList<Object> results = new ArrayList<Object>();
        ModuleKey module = ModuleKeys.synthetic(uri, this.workingDir.toUri(), uri, text, false);
        try {
            resolved = module.resolve(this.securityManager);
        }
        catch (SecurityManagerException e4) {
            throw new VmExceptionBuilder().withCause(e4).build();
        }
        catch (IOException e5) {
            throw new AssertionError((Object)e5);
        }
        AstBuilder builder = new AstBuilder(VmUtils.loadSource(resolved), this.language, replState.module.getModuleInfo(), this.moduleResolver);
        List childrenExceptEof = replInputContext.children.subList(0, replInputContext.children.size() - 1);
        for (ParseTree tree : childrenExceptEof) {
            try {
                if (tree instanceof PklParser.ExprContext) {
                    ExpressionNode exprNode = (ExpressionNode)tree.accept(builder);
                    this.evaluateExpr(replState, exprNode, forceResults, results);
                    continue;
                }
                if (tree instanceof PklParser.ImportClauseContext) {
                    PklParser.ImportClauseContext importClause = (PklParser.ImportClauseContext)tree;
                    this.addStaticModuleProperty(builder.visitImportClause(importClause));
                    continue;
                }
                if (tree instanceof PklParser.ClassPropertyContext) {
                    PklParser.ClassPropertyContext classProperty = (PklParser.ClassPropertyContext)tree;
                    UnresolvedPropertyNode propertyNode = builder.visitClassProperty(classProperty);
                    ObjectMember property = this.addModuleProperty(propertyNode);
                    if (!evalDefinitions) continue;
                    this.evaluateMemberDef(replState, property, forceResults, results);
                    continue;
                }
                if (tree instanceof PklParser.ClazzContext) {
                    PklParser.ClazzContext clazz = (PklParser.ClazzContext)tree;
                    this.addStaticModuleProperty(builder.visitClazz(clazz));
                    continue;
                }
                if (tree instanceof PklParser.TypeAliasContext) {
                    PklParser.TypeAliasContext typeAlias = (PklParser.TypeAliasContext)tree;
                    this.addStaticModuleProperty(builder.visitTypeAlias(typeAlias));
                    continue;
                }
                if (tree instanceof PklParser.ClassMethodContext) {
                    PklParser.ClassMethodContext classMethod = (PklParser.ClassMethodContext)tree;
                    this.addModuleMethodDef(builder.visitClassMethod(classMethod));
                    continue;
                }
                if (tree instanceof PklParser.ModuleDeclContext || tree instanceof TerminalNode && tree.toString().equals(",")) continue;
                results.add(new ReplResponse.InternalError(new IllegalStateException("Unexpected parse result")));
            }
            catch (VmException e6) {
                results.add(new ReplResponse.EvalError(this.errorRenderer.render(e6)));
            }
        }
        return results;
    }

    private void addStaticModuleProperty(ObjectMember property) {
        this.replState.module.getPrototype().addProperty(property);
    }

    private ObjectMember addModuleProperty(UnresolvedPropertyNode propertyNode) {
        boolean needToCreateNewModuleToEnforceLateBinding;
        boolean bl = needToCreateNewModuleToEnforceLateBinding = !propertyNode.isLocal() && this.replState.module.hasMember(propertyNode.getName());
        if (needToCreateNewModuleToEnforceLateBinding) {
            this.replState.module = this.createEmptyReplModule(this.replState.module);
        }
        ResolveClassMemberNode resolveNode = new ResolveClassMemberNode(this.language, new FrameDescriptor(), propertyNode, this.replState.module.getVmClass());
        ClassProperty property = (ClassProperty)this.callNode.call(resolveNode.getCallTarget(), this.replState.module, this.replState.module);
        this.replState.module.getVmClass().addProperty(property);
        return property.getInitializer();
    }

    private void addModuleMethodDef(UnresolvedMethodNode methodNode) {
        boolean needToCreateNewModuleToEnforceLateBinding;
        boolean bl = needToCreateNewModuleToEnforceLateBinding = !methodNode.isLocal() && this.replState.module.getVmClass().hasDeclaredMethod(methodNode.getName());
        if (needToCreateNewModuleToEnforceLateBinding) {
            this.replState.module = this.createEmptyReplModule(this.replState.module);
        }
        ResolveClassMemberNode resolveNode = new ResolveClassMemberNode(this.language, new FrameDescriptor(), methodNode, this.replState.module.getVmClass());
        ClassMethod method = (ClassMethod)this.callNode.call(resolveNode.getCallTarget(), this.replState.module, this.replState.module);
        this.replState.module.getVmClass().addMethod(method);
    }

    private void evaluateExpr(ReplState replState, ExpressionNode exprNode, boolean forceResults, List<Object> results) {
        SimpleRootNode rootNode = new SimpleRootNode(this.language, new FrameDescriptor(), exprNode.getSourceSection(), "", exprNode);
        Object result2 = this.callNode.call(rootNode.getCallTarget(), replState.module, replState.module);
        if (forceResults) {
            VmValue.force(result2, false);
        }
        results.add(result2);
    }

    private void evaluateMemberDef(ReplState replState, ObjectMember memberDef, boolean forceResults, List<Object> results) {
        Object result2;
        Object object = result2 = memberDef.getConstantValue() != null ? memberDef.getConstantValue() : this.callNode.call(memberDef.getCallTarget(), replState.module, replState.module);
        if (forceResults) {
            VmValue.force(result2, false);
        }
        results.add(result2);
    }

    private List<ReplResponse> handleLoad(ReplRequest.Load request) {
        try {
            URI uri = IoUtils.resolve(this.workingDir.toUri(), request.uri);
            ModuleKey moduleToLoad = this.moduleResolver.resolve(uri);
            VmTyped loadedModule = this.language.loadModule(moduleToLoad);
            this.replState.module = this.createReplModule(loadedModule.getVmClass().getDeclaredProperties(), loadedModule.getVmClass().getDeclaredMethods(), loadedModule.getMembers(), loadedModule.getParent());
            return List.of();
        }
        catch (VmException e2) {
            return List.of(new ReplResponse.EvalError(this.errorRenderer.render(e2)));
        }
    }

    private List<ReplResponse> handleCompletion(ReplRequest.Completion request) {
        VmObjectLike composite;
        HashSet<String> members2 = new HashSet<String>();
        if (IoUtils.isWhitespace(request.text)) {
            this.collectMembers(members2, BaseModule.getModule());
            this.collectMembers(members2, this.replState.module);
            return List.of(new ReplResponse.Completion(members2));
        }
        ReplState tempModule = new ReplState(this.createReplModule(this.replState.module.getVmClass().getDeclaredProperties(), this.replState.module.getVmClass().getDeclaredMethods(), this.replState.module.getMembers(), this.replState.module.getParent()));
        List<Object> results = this.evaluate(tempModule, request.id, request.text, false, false);
        if (results.isEmpty()) {
            return List.of(ReplResponse.Completion.EMPTY);
        }
        Object lastResult = results.get(results.size() - 1);
        if (lastResult instanceof ReplResponse.EvalError || lastResult instanceof ReplResponse.IncompleteInput) {
            return List.of(ReplResponse.Completion.EMPTY);
        }
        assert (!(lastResult instanceof ReplResponse));
        if (lastResult instanceof VmObjectLike) {
            VmObjectLike objectLike = (VmObjectLike)lastResult;
            composite = objectLike;
        } else {
            composite = VmUtils.getClass(lastResult).getPrototype();
        }
        this.collectMembers(members2, composite);
        return List.of(new ReplResponse.Completion(members2));
    }

    private void collectMembers(Set<String> members2, VmObjectLike composite) {
        composite.iterateMembers((key2, prop) -> {
            if (key2 instanceof Identifier) {
                members2.add(key2.toString());
            }
            return true;
        });
        composite.getVmClass().visitMethodDefsTopDown(fun -> members2.add(fun.getName() + (fun.getParameterCount() == 0 ? "()" : "(")));
    }

    private List<ReplResponse> handleReset() {
        this.replState.module = this.createEmptyReplModule(BaseModule.getModuleClass().getPrototype());
        return List.of();
    }

    private VmTyped createEmptyReplModule(@Nullable VmTyped parent) {
        return this.createReplModule(List.of(), List.of(), EconomicMaps.create(), parent);
    }

    private VmTyped createReplModule(Iterable<ClassProperty> propertyDefs, Iterable<ClassMethod> methodDefs, UnmodifiableEconomicMap<Object, ObjectMember> moduleMembers, @Nullable VmTyped parent) {
        ResolvedModuleKey resolvedModuleKey;
        URI uri = URI.create("repl:repl");
        PClassInfo<?> classInfo = PClassInfo.get("repl", "module", uri);
        ModuleKey moduleKey = ModuleKeys.synthetic(uri, this.workingDir.toUri(), uri, "", false);
        try {
            resolvedModuleKey = moduleKey.resolve(this.securityManager);
        }
        catch (IOException | SecurityManagerException e2) {
            throw new RuntimeException(e2);
        }
        ModuleInfo moduleInfo = new ModuleInfo(VmUtils.unavailableSourceSection(), VmUtils.unavailableSourceSection(), null, "repl", moduleKey, resolvedModuleKey, false);
        VmTyped module = new VmTyped(VmUtils.createEmptyMaterializedFrame(), null, null, moduleMembers);
        module.setExtraStorage(moduleInfo);
        VmClass clazz = new VmClass(VmUtils.unavailableSourceSection(), VmUtils.unavailableSourceSection(), null, List.of(), 0, classInfo, List.of(), module);
        if (parent != null) {
            VmClass superclass = parent.getVmClass();
            TypeNode supertypeNode = TypeNode.forClass(VmUtils.unavailableSourceSection(), superclass);
            clazz.initSupertype(supertypeNode, superclass);
        }
        clazz.addProperties(propertyDefs);
        clazz.addMethods(methodDefs);
        return module;
    }

    private String render(Object value2) {
        return VmValueRenderer.multiLine(Integer.MAX_VALUE).render(value2);
    }

    private static class ReplState {
        VmTyped module;

        public ReplState(VmTyped module) {
            this.module = module;
        }
    }
}

