/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.runtime;

import org.pkl.core.Release;
import org.pkl.core.Version;
import org.pkl.core.parser.antlr.PklParser;
import org.pkl.core.runtime.BaseModule;
import org.pkl.core.runtime.Identifier;
import org.pkl.core.runtime.VmExceptionBuilder;
import org.pkl.core.runtime.VmTyped;
import org.pkl.core.runtime.VmUtils;
import org.pkl.core.util.Nullable;
import org.pkl.thirdparty.antlr.v4.runtime.ParserRuleContext;
import org.pkl.thirdparty.antlr.v4.runtime.RuleContext;
import org.pkl.thirdparty.antlr.v4.runtime.Token;
import org.pkl.thirdparty.antlr.v4.runtime.tree.TerminalNode;
import org.pkl.thirdparty.truffle.api.nodes.Node;

final class MinPklVersionChecker {
    private static final Version currentVersion = Release.current().version();
    private static final Version currentMajorMinorPatchVersion = currentVersion.toNormal();

    MinPklVersionChecker() {
    }

    static void check(VmTyped module, @Nullable Node importNode) {
        assert (module.isModuleObject());
        for (VmTyped ann : module.getModuleInfo().getAnnotations()) {
            if (ann.getVmClass() != BaseModule.getModuleInfoClass()) continue;
            Version requiredVersion = Version.parse((String)VmUtils.readMember(ann, Identifier.MIN_PKL_VERSION));
            MinPklVersionChecker.doCheck(module.getModuleInfo().getModuleName(), requiredVersion, importNode);
            return;
        }
    }

    static void check(String moduleName, @Nullable ParserRuleContext ctx, @Nullable Node importNode) {
        if (!(ctx instanceof PklParser.ModuleContext)) {
            return;
        }
        PklParser.ModuleContext moduleCtx = (PklParser.ModuleContext)ctx;
        PklParser.ModuleDeclContext moduleDeclCtx = moduleCtx.moduleDecl();
        if (moduleDeclCtx == null) {
            return;
        }
        for (PklParser.AnnotationContext annotationContext : moduleDeclCtx.annotation()) {
            PklParser.ObjectBodyContext objectBodyCtx;
            if (!Identifier.MODULE_INFO.toString().equals(MinPklVersionChecker.getLastIdText(annotationContext.type())) || (objectBodyCtx = annotationContext.objectBody()) == null) continue;
            for (PklParser.ObjectMemberContext objectMemberContext : objectBodyCtx.objectMember()) {
                Version version;
                String versionText;
                if (!(objectMemberContext instanceof PklParser.ObjectPropertyContext)) continue;
                PklParser.ObjectPropertyContext propertyCtx = (PklParser.ObjectPropertyContext)objectMemberContext;
                if (!Identifier.MIN_PKL_VERSION.toString().equals(MinPklVersionChecker.getText(propertyCtx.Identifier())) || (versionText = MinPklVersionChecker.getText(propertyCtx.expr())) == null) continue;
                try {
                    version = Version.parse(versionText.substring(1, versionText.length() - 1));
                }
                catch (IllegalArgumentException e2) {
                    return;
                }
                MinPklVersionChecker.doCheck(moduleName, version, importNode);
                return;
            }
        }
    }

    @Nullable
    private static String getText(@Nullable RuleContext ruleCtx) {
        return ruleCtx == null ? null : ruleCtx.getText();
    }

    @Nullable
    private static String getLastIdText(@Nullable PklParser.TypeContext typeCtx) {
        if (!(typeCtx instanceof PklParser.DeclaredTypeContext)) {
            return null;
        }
        PklParser.DeclaredTypeContext declCtx = (PklParser.DeclaredTypeContext)typeCtx;
        Token token = declCtx.qualifiedIdentifier().Identifier;
        return token == null ? null : token.getText();
    }

    @Nullable
    private static String getText(@Nullable TerminalNode idCtx) {
        return idCtx == null ? null : idCtx.getText();
    }

    private static void doCheck(String moduleName, @Nullable Version requiredVersion, @Nullable Node importNode) {
        if (requiredVersion == null || currentMajorMinorPatchVersion.compareTo(requiredVersion) >= 0) {
            return;
        }
        throw new VmExceptionBuilder().withOptionalLocation(importNode).evalError("incompatiblePklVersion", moduleName, requiredVersion, currentVersion).build();
    }
}

