/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.runtime;

import java.util.Iterator;
import org.pkl.core.runtime.VmExceptionBuilder;
import org.pkl.core.runtime.VmList;
import org.pkl.core.runtime.VmListing;
import org.pkl.core.runtime.VmNull;
import org.pkl.core.runtime.VmPair;
import org.pkl.core.runtime.VmUtils;
import org.pkl.core.runtime.VmValue;
import org.pkl.core.runtime.VmValueRenderer;
import org.pkl.thirdparty.paguro.collections.UnmodIterable;
import org.pkl.thirdparty.paguro.xform.Xform;
import org.pkl.thirdparty.truffle.api.CompilerDirectives;

public abstract class VmCollection
extends VmValue
implements Iterable<Object> {
    public abstract int getLength();

    public abstract boolean isEmpty();

    @Override
    public boolean isSequence() {
        return true;
    }

    public abstract VmCollection add(Object var1);

    public abstract VmCollection concatenate(VmCollection var1);

    public abstract Iterator<Object> reverseIterator();

    public abstract Builder<? extends VmCollection> builder();

    public final void checkNonEmpty() {
        if (this.isEmpty()) {
            CompilerDirectives.transferToInterpreter();
            throw new VmExceptionBuilder().evalError("expectedNonEmptyCollection", new Object[0]).withProgramValue("Collection", this).build();
        }
    }

    public abstract boolean isLengthOne();

    public final void checkLengthOne() {
        if (!this.isLengthOne()) {
            CompilerDirectives.transferToInterpreter();
            throw new VmExceptionBuilder().evalError("expectedSingleElementCollection", new Object[0]).withProgramValue("Collection", this).build();
        }
    }

    protected static void checkPositive(long n) {
        VmUtils.checkPositive(n);
    }

    @CompilerDirectives.TruffleBoundary
    public final boolean startsWith(VmCollection other) {
        if (this.getLength() < other.getLength()) {
            return false;
        }
        Iterator iter = this.iterator();
        Iterator otherIter = other.iterator();
        while (otherIter.hasNext()) {
            if (iter.next().equals(otherIter.next())) continue;
            return false;
        }
        return true;
    }

    @CompilerDirectives.TruffleBoundary
    public final boolean endsWith(VmCollection other) {
        if (this.getLength() < other.getLength()) {
            return false;
        }
        Iterator<Object> iter = this.reverseIterator();
        Iterator<Object> otherIter = other.reverseIterator();
        while (otherIter.hasNext()) {
            if (iter.next().equals(otherIter.next())) continue;
            return false;
        }
        return true;
    }

    @CompilerDirectives.TruffleBoundary
    public final VmList replaceRange(long start2, long exclusiveEnd, VmCollection replacement) {
        UnmodIterable result2 = ((Xform)((Xform)Xform.of(this).take(start2)).concat((Iterable)replacement)).concat((Iterable)Xform.of(this).drop(exclusiveEnd));
        return VmList.create(result2);
    }

    @CompilerDirectives.TruffleBoundary
    public final Object replaceRangeOrNull(long start2, long exclusiveEnd, VmCollection replacement) {
        int length2 = this.getLength();
        if (start2 < 0L || start2 > (long)length2) {
            return VmNull.withoutDefault();
        }
        if (exclusiveEnd < start2 || exclusiveEnd > (long)length2) {
            return VmNull.withoutDefault();
        }
        UnmodIterable result2 = ((Xform)((Xform)Xform.of(this).take(start2)).concat((Iterable)replacement)).concat((Iterable)Xform.of(this).drop(exclusiveEnd));
        return VmList.create(result2);
    }

    @CompilerDirectives.TruffleBoundary
    public final VmCollection flatten() {
        Builder<? extends VmCollection> builder = this.builder();
        for (Object elem : this) {
            if (elem instanceof Iterable) {
                Iterable iterable = (Iterable)elem;
                builder.addAll(iterable);
                continue;
            }
            if (elem instanceof VmListing) {
                VmListing listing = (VmListing)elem;
                listing.forceAndIterateMemberValues((key2, member, value2) -> {
                    builder.add(value2);
                    return true;
                });
                continue;
            }
            CompilerDirectives.transferToInterpreter();
            throw new VmExceptionBuilder().evalError("cannotFlattenCollectionWithNonCollectionElement", new Object[0]).withProgramValue("Element", elem).build();
        }
        return builder.build();
    }

    @CompilerDirectives.TruffleBoundary
    public final VmCollection zip(VmCollection other) {
        Builder<? extends VmCollection> builder = this.builder();
        Iterator iter1 = this.iterator();
        Iterator iter2 = other.iterator();
        while (iter1.hasNext() && iter2.hasNext()) {
            builder.add(new VmPair(iter1.next(), iter2.next()));
        }
        return builder.build();
    }

    @CompilerDirectives.TruffleBoundary
    public final String join(String separator) {
        if (this.isEmpty()) {
            return "";
        }
        Iterator iter = this.iterator();
        StringBuilder builder = new StringBuilder();
        builder.append(iter.next());
        while (iter.hasNext()) {
            builder.append(separator);
            builder.append(iter.next());
        }
        return builder.toString();
    }

    public final String toString() {
        return VmValueRenderer.multiLine(Integer.MAX_VALUE).render(this);
    }

    public static interface Builder<T extends VmCollection> {
        public void add(Object var1);

        public void addAll(Iterable<?> var1);

        public T build();
    }
}

