/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.runtime;

import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import org.pkl.core.Logger;
import org.pkl.core.SecurityManager;
import org.pkl.core.StackFrameTransformer;
import org.pkl.core.http.HttpClient;
import org.pkl.core.module.ProjectDependenciesManager;
import org.pkl.core.packages.PackageResolver;
import org.pkl.core.runtime.ModuleCache;
import org.pkl.core.runtime.ModuleResolver;
import org.pkl.core.runtime.ResourceManager;
import org.pkl.core.runtime.VmLanguage;
import org.pkl.core.util.LateInit;
import org.pkl.core.util.Nullable;
import org.pkl.thirdparty.truffle.api.TruffleLanguage;
import org.pkl.thirdparty.truffle.api.nodes.Node;

public final class VmContext {
    private static final TruffleLanguage.ContextReference<VmContext> REFERENCE = TruffleLanguage.ContextReference.create(VmLanguage.class);
    @LateInit
    private Holder holder;

    public static VmContext get(@Nullable Node node) {
        return REFERENCE.get(node);
    }

    public void initialize(Holder holder) {
        assert (this.holder == null);
        this.holder = holder;
    }

    public ModuleCache getModuleCache() {
        return this.holder.moduleCache;
    }

    @Nullable
    public Path getModuleCacheDir() {
        return this.holder.moduleCacheDir;
    }

    public StackFrameTransformer getFrameTransformer() {
        return this.holder.frameTransformer;
    }

    public SecurityManager getSecurityManager() {
        return this.holder.securityManager;
    }

    public HttpClient getHttpClient() {
        return this.holder.httpClient;
    }

    public ModuleResolver getModuleResolver() {
        return this.holder.moduleResolver;
    }

    public ResourceManager getResourceManager() {
        return this.holder.resourceManager;
    }

    public Logger getLogger() {
        return this.holder.logger;
    }

    public Map<String, String> getEnvironmentVariables() {
        return this.holder.environmentVariables;
    }

    public Map<String, String> getExternalProperties() {
        return this.holder.externalProperties;
    }

    @Nullable
    public PackageResolver getPackageResolver() {
        return this.holder.packageResolver;
    }

    @Nullable
    public ProjectDependenciesManager getProjectDependenciesManager() {
        return this.holder.projectDependenciesManager;
    }

    public static final class Holder {
        private static final String OUTPUT_FORMAT_KEY = "pkl.outputFormat";
        private final StackFrameTransformer frameTransformer;
        private final SecurityManager securityManager;
        private final HttpClient httpClient;
        private final ModuleResolver moduleResolver;
        private final ResourceManager resourceManager;
        private final Logger logger;
        private final Map<String, String> environmentVariables;
        private final Path moduleCacheDir;
        private final Map<String, String> externalProperties;
        private final ModuleCache moduleCache;
        @Nullable
        private final PackageResolver packageResolver;
        @Nullable
        private final ProjectDependenciesManager projectDependenciesManager;

        public Holder(StackFrameTransformer frameTransformer, SecurityManager securityManager2, HttpClient httpClient2, ModuleResolver moduleResolver, ResourceManager resourceManager, Logger logger, Map<String, String> environmentVariables2, Map<String, String> externalProperties2, @Nullable Path moduleCacheDir2, @Nullable String outputFormat, @Nullable PackageResolver packageResolver, @Nullable ProjectDependenciesManager projectDependenciesManager) {
            this.frameTransformer = frameTransformer;
            this.securityManager = securityManager2;
            this.httpClient = httpClient2;
            this.moduleResolver = moduleResolver;
            this.resourceManager = resourceManager;
            this.logger = logger;
            this.environmentVariables = environmentVariables2;
            this.moduleCacheDir = moduleCacheDir2;
            HashMap<String, String> props = new HashMap<String, String>(externalProperties2);
            if (outputFormat != null) {
                props.put(OUTPUT_FORMAT_KEY, outputFormat);
            }
            this.externalProperties = props;
            this.moduleCache = new ModuleCache();
            this.packageResolver = packageResolver;
            this.projectDependenciesManager = projectDependenciesManager;
        }
    }
}

