/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.runtime;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.pkl.core.PklException;
import org.pkl.core.StackFrame;
import org.pkl.core.StackFrameTransformer;
import org.pkl.core.runtime.StackTraceRenderer;
import org.pkl.core.runtime.VmExceptionRenderer;
import org.pkl.core.runtime.VmValueRenderer;
import org.pkl.core.util.Nullable;
import org.pkl.thirdparty.truffle.api.CallTarget;
import org.pkl.thirdparty.truffle.api.CompilerDirectives;
import org.pkl.thirdparty.truffle.api.exception.AbstractTruffleException;
import org.pkl.thirdparty.truffle.api.nodes.Node;
import org.pkl.thirdparty.truffle.api.source.SourceSection;

public abstract class VmException
extends AbstractTruffleException {
    private final boolean isExternalMessage;
    private final Object[] messageArguments;
    private final List<ProgramValue> programValues;
    @Nullable
    private final SourceSection sourceSection;
    @Nullable
    private final String memberName;
    @Nullable
    protected String hint;
    private final Map<CallTarget, StackFrame> insertedStackFrames = new HashMap<CallTarget, StackFrame>();

    public VmException(String message, @Nullable Throwable cause, boolean isExternalMessage, Object[] messageArguments, List<ProgramValue> programValues, @Nullable Node location, @Nullable SourceSection sourceSection, @Nullable String memberName, @Nullable String hint) {
        super(message, cause, -1, location);
        this.isExternalMessage = isExternalMessage;
        this.messageArguments = messageArguments;
        this.programValues = programValues;
        this.sourceSection = sourceSection;
        this.memberName = memberName;
        this.hint = hint;
    }

    public final boolean isExternalMessage() {
        return this.isExternalMessage;
    }

    public final Object[] getMessageArguments() {
        return this.messageArguments;
    }

    public final List<ProgramValue> getProgramValues() {
        return this.programValues;
    }

    @Nullable
    public final SourceSection getSourceSection() {
        return this.sourceSection;
    }

    @Nullable
    public final String getMemberName() {
        return this.memberName;
    }

    @Nullable
    public String getHint() {
        return this.hint;
    }

    public void setHint(@Nullable String hint) {
        this.hint = hint;
    }

    public final Map<CallTarget, StackFrame> getInsertedStackFrames() {
        return this.insertedStackFrames;
    }

    @CompilerDirectives.TruffleBoundary
    public PklException toPklException(StackFrameTransformer transformer) {
        VmExceptionRenderer renderer = new VmExceptionRenderer(new StackTraceRenderer(transformer));
        String rendered = renderer.render(this);
        return new PklException(rendered);
    }

    public static final class ProgramValue {
        private static final VmValueRenderer valueRenderer = VmValueRenderer.singleLine(80);
        public final String name;
        public final Object value;

        public ProgramValue(String name, Object value2) {
            this.name = name;
            this.value = value2;
        }

        @CompilerDirectives.TruffleBoundary
        public String toString() {
            return valueRenderer.render(this.value);
        }
    }

    public static enum Kind {
        EVAL_ERROR,
        UNDEFINED_VALUE,
        BUG;

    }
}

