/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.runtime;

import java.util.function.BiFunction;
import org.pkl.core.ast.PklRootNode;
import org.pkl.core.ast.member.ObjectMember;
import org.pkl.core.runtime.BaseModule;
import org.pkl.core.runtime.VmClass;
import org.pkl.core.runtime.VmExceptionBuilder;
import org.pkl.core.runtime.VmObjectLike;
import org.pkl.core.runtime.VmValueConverter;
import org.pkl.core.runtime.VmValueVisitor;
import org.pkl.core.util.EconomicMaps;
import org.pkl.core.util.Nullable;
import org.pkl.thirdparty.graalvm.collections.UnmodifiableEconomicMap;
import org.pkl.thirdparty.truffle.api.CompilerDirectives;
import org.pkl.thirdparty.truffle.api.RootCallTarget;
import org.pkl.thirdparty.truffle.api.frame.MaterializedFrame;

public final class VmFunction
extends VmObjectLike {
    private final Object thisValue;
    private final int paramCount;
    private final PklRootNode rootNode;

    public VmFunction(MaterializedFrame enclosingFrame, Object thisValue, int paramCount, PklRootNode rootNode, @Nullable Object extraStorage) {
        super(enclosingFrame);
        this.thisValue = thisValue;
        this.paramCount = paramCount;
        this.rootNode = rootNode;
        this.extraStorage = extraStorage;
    }

    public RootCallTarget getCallTarget() {
        return this.rootNode.getCallTarget();
    }

    public int getParameterCount() {
        return this.paramCount;
    }

    public Object apply(Object arg1) {
        return this.getCallTarget().call(this.thisValue, this, arg1);
    }

    public String applyString(Object arg1) {
        Object result2 = this.apply(arg1);
        if (result2 instanceof String) {
            String string = (String)result2;
            return string;
        }
        CompilerDirectives.transferToInterpreter();
        throw new VmExceptionBuilder().typeMismatch(result2, BaseModule.getStringClass()).build();
    }

    public Object apply(Object arg1, Object arg2) {
        return this.getCallTarget().call(this.thisValue, this, arg1, arg2);
    }

    public VmFunction copy(int newParamCount, @Nullable PklRootNode newRootNode, @Nullable Object newExtraStorage) {
        return new VmFunction(this.enclosingFrame, this.thisValue, newParamCount, newRootNode == null ? this.rootNode : newRootNode, newExtraStorage);
    }

    public Object getThisValue() {
        return this.thisValue;
    }

    @Override
    public VmObjectLike getParent() {
        return this.getPrototype();
    }

    @Override
    public boolean hasMember(Object key2) {
        return false;
    }

    @Override
    @Nullable
    public ObjectMember getMember(Object key2) {
        return null;
    }

    @Override
    public UnmodifiableEconomicMap<Object, ObjectMember> getMembers() {
        return EconomicMaps.create();
    }

    @Override
    @Nullable
    public Object getCachedValue(Object key2) {
        return null;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public void setCachedValue(Object key2, Object value2) {
        throw new VmExceptionBuilder().bug("Class `VmFunction` does not support method `setCachedValue()`.", new Object[0]).build();
    }

    @Override
    public boolean hasCachedValue(Object key2) {
        throw new VmExceptionBuilder().bug("Class `VmFunction` does not support method `hasCachedValue()`.", new Object[0]).build();
    }

    @Override
    public boolean iterateMemberValues(VmObjectLike.MemberValueConsumer consumer2) {
        return true;
    }

    @Override
    public boolean forceAndIterateMemberValues(VmObjectLike.ForcedMemberValueConsumer consumer2) {
        return true;
    }

    @Override
    public boolean iterateAlreadyForcedMemberValues(VmObjectLike.ForcedMemberValueConsumer consumer2) {
        return true;
    }

    @Override
    public boolean iterateMembers(BiFunction<Object, ObjectMember, Boolean> consumer2) {
        return true;
    }

    @Override
    public VmClass getVmClass() {
        return BaseModule.getFunctionNClass(this.paramCount);
    }

    @Override
    public void force(boolean allowUndefinedValues, boolean recurse) {
    }

    @Override
    public void force(boolean allowUndefinedValues) {
    }

    @Override
    public Object export() {
        throw new VmExceptionBuilder().evalError("cannotExportValue", this.getVmClass()).build();
    }

    @Override
    public void accept(VmValueVisitor visitor2) {
        visitor2.visitFunction(this);
    }

    @Override
    public <T> T accept(VmValueConverter<T> converter, Iterable<Object> path2) {
        return converter.convertFunction(this, path2);
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj;
    }

    public int hashCode() {
        return System.identityHashCode(this);
    }
}

