/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.runtime;

import java.util.NoSuchElementException;
import java.util.PrimitiveIterator;
import org.pkl.core.runtime.BaseModule;
import org.pkl.core.runtime.VmClass;
import org.pkl.core.runtime.VmExceptionBuilder;
import org.pkl.core.runtime.VmValue;
import org.pkl.core.runtime.VmValueConverter;
import org.pkl.core.runtime.VmValueVisitor;
import org.pkl.core.util.Nullable;
import org.pkl.thirdparty.truffle.api.CompilerDirectives;

@CompilerDirectives.ValueType
public final class VmIntSeq
extends VmValue
implements Iterable<Long> {
    public final long start;
    public final long end;
    public final long step;
    public final long last;

    public VmIntSeq(long start2, long end2, long step2) {
        assert (step2 != 0L);
        this.start = start2;
        this.end = end2;
        this.step = step2;
        this.last = step2 > 0L ? (start2 >= end2 ? end2 : end2 - VmIntSeq.diffMod(end2, start2, step2)) : (start2 <= end2 ? end2 : end2 + VmIntSeq.diffMod(start2, end2, -step2));
    }

    public boolean isEmpty() {
        return this.step > 0L ? this.start > this.last : this.start < this.last;
    }

    public long getLength() {
        return Math.abs((this.end - this.start) / this.step) + 1L;
    }

    @Override
    public VmClass getVmClass() {
        return BaseModule.getIntSeqClass();
    }

    @Override
    public void force(boolean allowUndefinedValues) {
    }

    @Override
    public Object export() {
        throw new VmExceptionBuilder().evalError("cannotExportValue", this.getVmClass()).build();
    }

    @Override
    public void accept(VmValueVisitor visitor2) {
        visitor2.visitIntSeq(this);
    }

    @Override
    public <T> T accept(VmValueConverter<T> converter, Iterable<Object> path2) {
        return converter.convertIntSeq(this, path2);
    }

    public PrimitiveIterator.OfLong iterator() {
        return new PrimitiveIterator.OfLong(){
            boolean hasNext;
            long next;
            {
                this.hasNext = !VmIntSeq.this.isEmpty();
                this.next = this.hasNext ? VmIntSeq.this.start : VmIntSeq.this.last;
            }

            @Override
            public boolean hasNext() {
                return this.hasNext;
            }

            @Override
            public long nextLong() {
                long result2 = this.next;
                if (result2 == VmIntSeq.this.last) {
                    if (!this.hasNext) {
                        CompilerDirectives.transferToInterpreter();
                        throw new NoSuchElementException();
                    }
                    this.hasNext = false;
                } else {
                    this.next += VmIntSeq.this.step;
                }
                return result2;
            }
        };
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof VmIntSeq)) {
            return false;
        }
        VmIntSeq other = (VmIntSeq)obj;
        return this.isEmpty() ? other.isEmpty() : this.start == other.start && this.last == other.last && this.step == other.step;
    }

    public int hashCode() {
        if (this.isEmpty()) {
            return 1;
        }
        int result2 = 1;
        result2 = result2 * 31 + Long.hashCode(this.start);
        result2 = result2 * 31 + Long.hashCode(this.last);
        result2 = result2 * 31 + Long.hashCode(this.step);
        return result2;
    }

    @CompilerDirectives.TruffleBoundary
    public String toString() {
        return this.step == 1L ? "IntSeq(" + this.start + ", " + this.end + ")" : "IntSeq(" + this.start + ", " + this.end + ").step(" + this.step + ")";
    }

    private static long mod(long a2, long b2) {
        long mod = a2 % b2;
        return mod >= 0L ? mod : mod + b2;
    }

    private static long diffMod(long a2, long b2, long c) {
        return VmIntSeq.mod(VmIntSeq.mod(a2, c) - VmIntSeq.mod(b2, c), c);
    }
}

