/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.runtime;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.pkl.core.ast.member.ObjectMember;
import org.pkl.core.runtime.BaseModule;
import org.pkl.core.runtime.Identifier;
import org.pkl.core.runtime.VmClass;
import org.pkl.core.runtime.VmObject;
import org.pkl.core.runtime.VmUtils;
import org.pkl.core.runtime.VmValue;
import org.pkl.core.runtime.VmValueConverter;
import org.pkl.core.runtime.VmValueVisitor;
import org.pkl.core.util.EconomicMaps;
import org.pkl.core.util.Nullable;
import org.pkl.thirdparty.graalvm.collections.UnmodifiableEconomicMap;
import org.pkl.thirdparty.graalvm.collections.UnmodifiableMapCursor;
import org.pkl.thirdparty.truffle.api.CompilerDirectives;
import org.pkl.thirdparty.truffle.api.frame.MaterializedFrame;

public final class VmListing
extends VmObject {
    private final int length;

    public static VmListing empty() {
        return EmptyHolder.EMPTY;
    }

    public VmListing(MaterializedFrame enclosingFrame, VmObject parent, UnmodifiableEconomicMap<Object, ObjectMember> members2, int length2) {
        super(enclosingFrame, Objects.requireNonNull(parent), members2);
        this.length = length2;
    }

    public static boolean isDefaultProperty(Object propertyKey) {
        return propertyKey == Identifier.DEFAULT;
    }

    public int getLength() {
        return this.length;
    }

    public boolean isEmpty() {
        return this.length == 0;
    }

    @Override
    public boolean isSequence() {
        return true;
    }

    @Override
    public VmClass getVmClass() {
        return BaseModule.getListingClass();
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public List<Object> export() {
        ArrayList<Object> properties2 = new ArrayList<Object>(EconomicMaps.size(this.cachedValues));
        this.iterateMemberValues((key2, prop, value2) -> {
            if (VmListing.isDefaultProperty(key2)) {
                return true;
            }
            properties2.add(VmValue.exportNullable(value2));
            return true;
        });
        return properties2;
    }

    @Override
    public void accept(VmValueVisitor visitor2) {
        visitor2.visitListing(this);
    }

    @Override
    public <T> T accept(VmValueConverter<T> converter, Iterable<Object> path2) {
        return converter.convertListing(this, path2);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof VmListing)) {
            return false;
        }
        VmListing other = (VmListing)obj;
        if (this.length != other.length) {
            return false;
        }
        this.force(false);
        other.force(false);
        UnmodifiableMapCursor cursor = this.cachedValues.getEntries();
        while (cursor.advance()) {
            Object key2 = cursor.getKey();
            if (key2 instanceof Identifier) continue;
            Object value2 = cursor.getValue();
            assert (value2 != null);
            Object otherValue = other.getCachedValue(key2);
            if (value2.equals(otherValue)) continue;
            return false;
        }
        return true;
    }

    @CompilerDirectives.TruffleBoundary
    public int hashCode() {
        if (this.cachedHash != 0) {
            return this.cachedHash;
        }
        this.force(false);
        int result2 = 0;
        UnmodifiableMapCursor cursor = this.cachedValues.getEntries();
        while (cursor.advance()) {
            Object key2 = cursor.getKey();
            if (key2 instanceof Identifier) continue;
            Object value2 = cursor.getValue();
            assert (value2 != null);
            result2 = 31 * result2 + value2.hashCode();
        }
        this.cachedHash = result2;
        return result2;
    }

    private static final class EmptyHolder {
        private static final VmListing EMPTY = new VmListing(VmUtils.createEmptyMaterializedFrame(), (VmObject)BaseModule.getListingClass().getPrototype(), EconomicMaps.create(), 0);

        private EmptyHolder() {
        }
    }
}

