/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.runtime;

import org.pkl.core.ast.member.ObjectMember;
import org.pkl.core.ast.member.SharedMemberNode;
import org.pkl.core.runtime.BaseModule;
import org.pkl.core.runtime.Identifier;
import org.pkl.core.runtime.VmDynamic;
import org.pkl.core.runtime.VmListing;
import org.pkl.core.runtime.VmMapping;
import org.pkl.core.runtime.VmObject;
import org.pkl.core.runtime.VmUtils;
import org.pkl.core.util.EconomicMaps;
import org.pkl.thirdparty.graalvm.collections.EconomicMap;

public final class VmObjectBuilder {
    private final EconomicMap<Object, ObjectMember> members;
    private int elementCount = 0;

    public VmObjectBuilder(int initialSize) {
        this.members = EconomicMaps.create(initialSize);
    }

    public VmObjectBuilder addProperty(Identifier name, Object value2) {
        EconomicMaps.put(this.members, name, VmUtils.createSyntheticObjectProperty(name, "", value2));
        return this;
    }

    public VmObjectBuilder addElement(Object value2) {
        EconomicMaps.put(this.members, Long.valueOf(this.elementCount++), VmUtils.createSyntheticObjectElement("", value2));
        return this;
    }

    public VmObjectBuilder addEntry(Object key2, Object value2) {
        EconomicMaps.put(this.members, key2, VmUtils.createSyntheticObjectEntry("", value2));
        return this;
    }

    public VmObjectBuilder addEntry(Object key2, SharedMemberNode valueNode) {
        ObjectMember entry = new ObjectMember(valueNode.getSourceSection(), valueNode.getHeaderSection(), 1024, null, "");
        entry.initMemberNode(valueNode);
        EconomicMaps.put(this.members, key2, entry);
        return this;
    }

    public VmListing toListing() {
        return new VmListing(VmUtils.createEmptyMaterializedFrame(), (VmObject)BaseModule.getListingClass().getPrototype(), this.members, this.elementCount);
    }

    public VmMapping toMapping() {
        return new VmMapping(VmUtils.createEmptyMaterializedFrame(), BaseModule.getMappingClass().getPrototype(), this.members);
    }

    public VmMapping toMapping(Object extraStorage) {
        VmMapping result2 = this.toMapping();
        result2.setExtraStorage(extraStorage);
        return result2;
    }

    public VmDynamic toDynamic() {
        return new VmDynamic(VmUtils.createEmptyMaterializedFrame(), (VmObject)BaseModule.getDynamicClass().getPrototype(), this.members, this.elementCount);
    }
}

