/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.runtime;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.pkl.core.ValueFormatter;
import org.pkl.core.runtime.BaseModule;
import org.pkl.core.runtime.VmClass;
import org.pkl.core.runtime.VmValue;
import org.pkl.core.runtime.VmValueConverter;
import org.pkl.core.runtime.VmValueVisitor;
import org.pkl.core.util.Nullable;
import org.pkl.thirdparty.truffle.api.CompilerDirectives;

@CompilerDirectives.ValueType
public final class VmRegex
extends VmValue {
    private final Pattern pattern;

    public VmRegex(Pattern pattern2) {
        this.pattern = pattern2;
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    @CompilerDirectives.TruffleBoundary
    public Matcher matcher(String input2) {
        return this.pattern.matcher(input2);
    }

    @Override
    public VmClass getVmClass() {
        return BaseModule.getRegexClass();
    }

    @Override
    public void force(boolean allowUndefinedValues) {
    }

    @Override
    public Pattern export() {
        return this.pattern;
    }

    @Override
    public void accept(VmValueVisitor visitor2) {
        visitor2.visitRegex(this);
    }

    @Override
    public <T> T accept(VmValueConverter<T> converter, Iterable<Object> path2) {
        return converter.convertRegex(this, path2);
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof VmRegex)) {
            return false;
        }
        VmRegex other = (VmRegex)obj;
        return this.pattern.pattern().equals(other.pattern.pattern());
    }

    public int hashCode() {
        return this.pattern.pattern().hashCode();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Regex(");
        ValueFormatter.withCustomStringDelimiters().formatStringValue(this.pattern.pattern(), (CharSequence)"", builder);
        builder.append(')');
        return builder.toString();
    }
}

