/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.runtime;

import java.math.RoundingMode;
import org.pkl.core.runtime.VmException;
import org.pkl.core.runtime.VmExceptionBuilder;
import org.pkl.core.util.MathUtils;
import org.pkl.thirdparty.truffle.api.CompilerDirectives;
import org.pkl.thirdparty.truffle.api.nodes.Node;

public final class VmSafeMath {
    private VmSafeMath() {
    }

    public static long negate(long x) {
        try {
            return Math.negateExact(x);
        }
        catch (ArithmeticException e2) {
            CompilerDirectives.transferToInterpreter();
            throw VmSafeMath.intOverflow();
        }
    }

    public static double negate(double x) {
        return -x;
    }

    public static long add(long x, long y) {
        try {
            return StrictMath.addExact(x, y);
        }
        catch (ArithmeticException e2) {
            CompilerDirectives.transferToInterpreter();
            throw VmSafeMath.intOverflow();
        }
    }

    public static double add(double x, double y) {
        return x + y;
    }

    public static long multiply(long x, long y) {
        try {
            return StrictMath.multiplyExact(x, y);
        }
        catch (ArithmeticException e2) {
            CompilerDirectives.transferToInterpreter();
            throw VmSafeMath.intOverflow();
        }
    }

    public static double multiply(double x, double y) {
        return x * y;
    }

    public static long truncatingDivide(long x, long y) {
        if (y == 0L) {
            CompilerDirectives.transferToInterpreter();
            throw VmSafeMath.divisionByZero();
        }
        long result2 = x / y;
        if ((x & y & result2) < 0L) {
            CompilerDirectives.transferToInterpreter();
            assert (x == Long.MIN_VALUE && y == -1L);
            throw VmSafeMath.intOverflow();
        }
        return result2;
    }

    public static long remainder(long x, long y) {
        return x % y;
    }

    public static double remainder(double x, double y) {
        return x % y;
    }

    public static int toInt32(long x) {
        try {
            return StrictMath.toIntExact(x);
        }
        catch (ArithmeticException e2) {
            CompilerDirectives.transferToInterpreter();
            throw new VmExceptionBuilder().evalError("intValueTooLarge", x).build();
        }
    }

    public static double truncate(double x) {
        if (x < 0.0) {
            return StrictMath.ceil(x);
        }
        return StrictMath.floor(x);
    }

    @CompilerDirectives.TruffleBoundary
    public static long toInt(double x, Node sourceNode) {
        try {
            return MathUtils.roundToLong(x, RoundingMode.DOWN);
        }
        catch (ArithmeticException e2) {
            CompilerDirectives.transferToInterpreter();
            throw new VmExceptionBuilder().withLocation(sourceNode).evalError(Double.isFinite(x) ? "cannotConvertLargeFloat" : "cannotConvertNonFiniteFloat", new VmException.ProgramValue("Float", x)).build();
        }
    }

    public static long increment(long x) {
        try {
            return Math.incrementExact(x);
        }
        catch (ArithmeticException e2) {
            CompilerDirectives.transferToInterpreter();
            throw VmSafeMath.intOverflow();
        }
    }

    public static long decrement(long x) {
        try {
            return Math.decrementExact(x);
        }
        catch (ArithmeticException e2) {
            CompilerDirectives.transferToInterpreter();
            throw VmSafeMath.intOverflow();
        }
    }

    public static long abs(long x) {
        if (x == Long.MIN_VALUE) {
            CompilerDirectives.transferToInterpreter();
            throw VmSafeMath.intOverflow();
        }
        return StrictMath.abs(x);
    }

    public static long pow(long x, long y) {
        assert (y >= 0L);
        if (y > Integer.MAX_VALUE) {
            if (x == 0L || x == 1L) {
                return x;
            }
            if (x == -1L) {
                return y % 2L == 0L ? 1L : -1L;
            }
            CompilerDirectives.transferToInterpreter();
            throw VmSafeMath.intOverflow();
        }
        try {
            return MathUtils.checkedPow(x, (int)y);
        }
        catch (ArithmeticException e2) {
            CompilerDirectives.transferToInterpreter();
            throw VmSafeMath.intOverflow();
        }
    }

    private static VmException intOverflow() {
        return new VmExceptionBuilder().evalError("integerOverflow", new Object[0]).build();
    }

    private static VmException divisionByZero() {
        return new VmExceptionBuilder().evalError("divisionByZero", new Object[0]).build();
    }
}

